package com.soss.system.service.impl;

import com.soss.common.exception.ServiceException;
import com.soss.common.utils.GenerateCode;
import com.soss.system.domain.Goods;
import com.soss.system.domain.GoodsCategory;
import com.soss.system.mapper.GoodsCategoryMapper;
import com.soss.system.mapper.GoodsMapper;
import com.soss.system.service.IGoodsCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 商品分类Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class GoodsCategoryServiceImpl implements IGoodsCategoryService
{
    @Autowired
    private GoodsCategoryMapper goodsCategoryMapper;
    @Autowired
    private GoodsMapper goodsMapper;

    /**
     * 查询商品分类
     * 
     * @param id 商品分类主键
     * @return 商品分类
     */
    @Override
    public GoodsCategory selectGoodsCategoryById(String id)
    {
        return goodsCategoryMapper.selectGoodsCategoryById(id);
    }

    /**
     * 查询商品分类列表
     * 
     * @param goodsCategory 商品分类
     * @return 商品分类
     */
    @Override
    public List<GoodsCategory> selectGoodsCategoryList(GoodsCategory goodsCategory)
    {
        List<GoodsCategory> goodsCategories = goodsCategoryMapper.selectGoodsCategoryList(goodsCategory);
        for (GoodsCategory category : goodsCategories) {
            category.setGoodsCount(goodsMapper.selectCount(category.getId()));
        }
        return goodsCategories;
    }

    /**
     * 新增商品分类
     * 
     * @param goodsCategory 商品分类
     * @return 结果
     */
    @Override
    public int insertGoodsCategory(GoodsCategory goodsCategory)
    {
        goodsCategory.setCode(GenerateCode.getCode("PC"));
        goodsCategory.setCreatedAt(new Date());
        goodsCategory.setUpdatedAt(new Date());
        goodsCategory.setIsDeleted("0");
        goodsCategoryMapper.insertGoodsCategory(goodsCategory);
        goodsCategory.setTurn(goodsCategory.getId().toString());
        return goodsCategoryMapper.updateGoodsCategory(goodsCategory);
    }

    /**
     * 修改商品分类
     * 
     * @param goodsCategory 商品分类
     * @return 结果
     */
    @Override
    public int updateGoodsCategory(GoodsCategory goodsCategory)
    {
        if("2".equals(goodsCategory.getState())){
            Goods goods = new Goods();
            goods.setCategory(goodsCategory.getId().toString());
            goods.setIsDeleted(0L);
            int size = goodsMapper.selectGoodsList(goods).size();
            if(size>0){
                throw new ServiceException("有商品还在使用，请先删除商品");
            }
        }
        return goodsCategoryMapper.updateGoodsCategory(goodsCategory);
    }

    /**
     * 批量删除商品分类
     * 
     * @param ids 需要删除的商品分类主键
     * @return 结果
     */
    @Override
    public int deleteGoodsCategoryByIds(String[] ids)
    {
        for (String id : ids) {
            Goods goods = new Goods();
            goods.setCategory(id);
            goods.setIsDeleted(0L);
            int size = goodsMapper.selectGoodsList(goods).size();
            if(size>0){
                throw new ServiceException("有商品还在使用，请先删除商品");
            }
        }
        return goodsCategoryMapper.deleteGoodsCategoryByIds(ids);
    }

    /**
     * 删除商品分类信息
     * 
     * @param id 商品分类主键
     * @return 结果
     */
    @Override
    public int deleteGoodsCategoryById(String id)
    {
        GoodsCategory goodsCategory = goodsCategoryMapper.selectGoodsCategoryById(id);
        goodsCategory.setIsDeleted("1");
        return goodsCategoryMapper.updateGoodsCategory(goodsCategory);
    }

    @Override
    public int turnOrder(String id, String pointer) {
        // pointer 1 向上  2向下
        List<GoodsCategory> goodsCategories = goodsCategoryMapper.selectGoodsCategoryList(new GoodsCategory());
        String lastId = null;
        int size = goodsCategories.size();
        for(int i=0;i<size;i++){
            GoodsCategory goodsCategory = goodsCategories.get(i);
            if (id.equals(goodsCategory.getId().toString())) {
                if ("1".equals(pointer)) {
                    int lastIdx = i - 1;
                    if (lastIdx < 0) {
                        lastId = id;
                    } else {
                        lastId = goodsCategories.get(lastIdx).getId().toString();
                    }
                } else if ("2".equals(pointer)) {
                    int lastIdx = i + 1;
                    if (lastIdx >= size) {
                        lastId = id;
                    } else {
                        lastId = goodsCategories.get(lastIdx).getId().toString();
                    }
                }
            }

        }
        GoodsCategory previousCategory = goodsCategoryMapper.selectGoodsCategoryById(id);
        GoodsCategory latterCategory = goodsCategoryMapper.selectGoodsCategoryById(lastId);
        String turn = previousCategory.getTurn();
        previousCategory.setTurn(latterCategory.getTurn());
        latterCategory.setTurn(turn);
        goodsCategoryMapper.updateGoodsCategory(previousCategory);
        goodsCategoryMapper.updateGoodsCategory(latterCategory);
        return 1;
    }
}
