package com.soss.system.service.impl;

import com.soss.common.enums.MachineState;
import com.soss.common.enums.ShopState;
import com.soss.common.exception.ServiceException;
import com.soss.system.domain.Machine;
import com.soss.system.domain.Shop;
import com.soss.system.mapper.MachineMapper;
import com.soss.system.mapper.ShopMapper;
import com.soss.system.service.IMachineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 机器Service业务层处理
 *
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class MachineServiceImpl implements IMachineService {
    @Autowired
    private MachineMapper machineMapper;
    @Autowired
    private ShopMapper shopMapper;

    /**
     * 查询机器
     *
     * @param id 机器主键
     * @return 机器
     */
    @Override
    public Machine selectMachineById(String id) {
        return machineMapper.selectMachineById(id);
    }

    /**
     * 查询机器列表
     * 
     * @param machine 机器
     * @return 机器
     */
    @Override
    public List<Machine> selectMachineList(Machine machine)
    {
        return machineMapper.selectMachineList(machine);
    }

    /**
     * 新增机器
     * 
     * @param machine 机器
     * @return 结果
     */
    @Override
    public int insertMachine(Machine machine)
    {
        return machineMapper.insertMachine(machine);
    }

    /**
     * 修改机器
     * 
     * @param machine 机器
     * @return 结果
     */
    @Override
    public int updateMachine(Machine machine)
    {
        return machineMapper.updateMachine(machine);
    }

    /**
     * 批量删除机器
     * 
     * @param ids 需要删除的机器主键
     * @return 结果
     */
    @Override
    public int deleteMachineByIds(String[] ids)
    {
        return machineMapper.deleteMachineByIds(ids);
    }

    /**
     * 删除机器信息
     *
     * @param id 机器主键
     * @return 结果
     */
    @Override
    public int deleteMachineById(String id) {
        return machineMapper.deleteMachineById(id);
    }

    @Override
    public List<Machine> getMachines(Long shopId) {
        Machine machine = new Machine();
        machine.setShopId(shopId);
        List<Machine> machines = machineMapper.selectMachineList(machine);
        return machines;
    }

    @Override
    @Transactional
    public String bindMachine(String code, Long shopId) {
        List<Machine> machines = getMachines(shopId);
        if (!machines.isEmpty()) {
            throw new ServiceException("目前只允许一个店铺绑定一台机器");
        }
        Machine machine1 = machineMapper.selectMachineByCode(code);
        if (machine1 == null) {
            throw new ServiceException("未查询到匹配的机器[code=" + code + "]");
        }
        if (machine1.getShopId() != null && machine1.getShopId() > 0) {
            throw new ServiceException("该机器已经被绑定，请先解绑再绑定");
        }
        machine1.setShopId(shopId);
        Date curTime = new Date();
        machine1.setState(MachineState.TO_BE_TEST.getState());
        machine1.setBindTime(curTime);
        machine1.setUpdatedAt(curTime);
        machineMapper.updateMachine(machine1);
        // 重新绑定机器后店铺进入测试中状态重新完成运营测试
        shopMapper.updateShop(new Shop(shopId, ShopState.TESTING.getState()));
        return "1";
    }

    @Override
    public int unbound(String id) {
        return machineMapper.deleteMachineById(id);
    }

    public Machine selectMachineByCode(String machineCode) {
        return machineMapper.selectMachineByCode(machineCode);
    }

    @Override
    public void saveMachineScreenRef(Integer machineId, Integer screenNo, String registerId) {
        machineMapper.saveMachineScreenRef(machineId, screenNo, registerId);
    }
}
