package com.soss.system.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@Component
@Slf4j
public class AreaUtil {
    //    private Map<String, Area> areaMap;
    private Map<String, String> provNameMap = new HashMap<>();
    private Map<String, String> areaOrCityFullNameMap = new HashMap<>();

    @PostConstruct
    public void init() {
        try {
            ClassPathResource resource = new ClassPathResource("province.json");
            byte[] bdata = FileCopyUtils.copyToByteArray(resource.getInputStream());
            String data = new String(bdata, StandardCharsets.UTF_8);
            JSONArray areaArray = JSONArray.parseArray(data);
            // areaMap = buildAreaTree(areaArray);
            deepAreaTree(areaArray, "");
        } catch (IOException e) {
            log.error("解析区域文件出错", e);
        }
    }

    private void deepAreaTree(JSONArray areaArray, String parentName) {
        if (CollectionUtils.isEmpty(areaArray)) {
            return;
        }
        for (int i = 0; i < areaArray.size(); i++) {
            JSONObject area = areaArray.getJSONObject(i);
            String code = area.getString("value");
            String label = area.getString("label");
            String curLabel = parentName + label;
            if (parentName.equals("")) {
                provNameMap.put(code, curLabel);
            } else {
                areaOrCityFullNameMap.put(code, curLabel);
            }
            JSONArray children = area.getJSONArray("children");
            deepAreaTree(children, curLabel);
        }
    }

    public String getProvNameByCode(String code) {
        return provNameMap.get(code);
    }

    public String getCityOrAreaNameByCode(String code) {
        return areaOrCityFullNameMap.get(code);
    }

    /*private Map<String, Area> buildAreaTree(JSONArray areaArray) {
        if (CollectionUtils.isEmpty(areaArray)) {
            return null;
        }
        Map<String, Area> areaMap = new HashMap<>();
        for (int i = 0; i < areaArray.size(); i++) {
            JSONObject area = areaArray.getJSONObject(i);
            String code = area.getString("value");
            String label = area.getString("label");
            JSONArray children = area.getJSONArray("children");
            areaMap.put(code, new Area(label, buildAreaTree(children)));
        }
        return areaMap;
    }

    public <T> void translateArea(List<T> ts) throws Exception {
        if (CollectionUtils.isEmpty(ts)) {
            return;
        }
        Map<String, Field> tfdMap = ReflectUtil.getFields(ts.get(0));
        for (T t : ts) {
            Map<String, Area> cityMap = translate(t, "province", "provinceDesc", tfdMap, areaMap);
            if (cityMap == null) continue;
            Map<String, Area> areaMap = translate(t, "city", "cityDesc", tfdMap, cityMap);
            if (areaMap == null) continue;
            translate(t, "area", "areaDesc", tfdMap, areaMap);
        }
    }

    private <T> Map<String, Area> translate(T t, String codeFieldName, String descFieldName,
                                            Map<String, Field> tfdMap, Map<String, Area> areaMap) throws Exception {
        if (CollectionUtils.isEmpty(areaMap)) {
            return null;
        }
        Field provField = tfdMap.get(codeFieldName);
        Field provDescField = tfdMap.get(descFieldName);
        if (provField == null || provDescField == null) {
            return null;
        }
        ReflectUtil.accessField(provField, provDescField);
        String province = (String) provField.get(t);
        if (!StringUtils.hasText(province)) {
            return null;
        }
        Area area = areaMap.get(province);
        if (area == null) return null;
        provDescField.set(t, area.getLabel());
        return area.getChildren();
    }

    @Data
    @AllArgsConstructor
    class Area {
        private String label;
        private Map<String, Area> children;
    }*/
}
