package com.soss.system.utils;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SendSmsUtil {

    // 短信API产品名称（短信产品名固定，无需修改）
    private static final String product = "Dysmsapi";

    // 短信API产品域名，接口地址固定，无需修改
    private static final String domain = "dysmsapi.aliyuncs.com";

    //阿里云短信服务accessKeyId（这里是取的yaml文件里面的配置，可自行填写）
    @Value("${sms.aliyun.accessKeyId}")
    private String accessKeyId;

    //阿里云短信服务accessKeySecret（这里是取的yaml文件里面的配置，可自行填写）
    @Value("${sms.aliyun.accessKeySecret}")
    private String accessKeySecret;

    //短信签名（这里是取的yaml文件里面的配置，可自行填写）
    @Value("${sms.aliyun.signName}")
    private String signName;

    //phone:要发送的手机号
    //templateCode:申请的短信模板
    //paramsJson:模板里面的参数和对应的值，处理成json字符串直接传进来
    public Boolean sendSms(String phone, String templateCode, String paramsJson)  {
        try {
            // 超时时间
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");

            // 初始化acsClient,暂不支持region化
            IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId, accessKeySecret);
            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
            IAcsClient acsClient = new DefaultAcsClient(profile);

            // 组装请求对象-具体描述见控制台-文档部分内容
            SendSmsRequest request = new SendSmsRequest();
            // 必填:待发送手机号
            request.setPhoneNumbers(phone);
            // 必填:短信签名-可在短信控制台中找到
            request.setSignName(signName);
            // 必填:短信模板code-可在短信控制台中找到
            request.setTemplateCode(templateCode);
            // 可选:模板中的变量替换JSON串
            request.setTemplateParam(paramsJson);

            //可能会抛出异常,try catch一下
            SendSmsResponse sendSmsResponse;
            try {
                //调用阿里云短信服务
                sendSmsResponse = acsClient.getAcsResponse(request);
            } catch (Exception e) {
                e.printStackTrace();
                log.error("调用阿里云短信服务异常！异常信息：" + e.getMessage());
                return false;
            }

            Boolean result;
            if (result = sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
                log.info("短信发送成功！内容：" + sendSmsResponse.getMessage());
            } else {
                log.error("短信发送失败！异常信息：" + sendSmsResponse.getMessage());
            }
            return result;
        }catch (Exception e){
  log.error("发送短信失败",e);
        }
return null;
    }
}
