package com.soss.web.controller.coffee;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.StringUtils;
import com.soss.system.domain.Machine;
import com.soss.system.domain.Shop;
import com.soss.system.jiguang.impl.JiGuangPushServiceImpl;
import com.soss.system.service.ICustomerService;
import com.soss.system.service.impl.MachineServiceImpl;
import com.soss.system.service.impl.OrderServiceImpl;
import com.soss.system.service.impl.OrderTakingServiceImpl;
import com.soss.system.service.impl.ShopServiceImpl;
import com.soss.system.utils.DistanceUtil;
import io.jsonwebtoken.lang.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.*;

import java.util.concurrent.TimeUnit;

@RestController
@RequestMapping("/application")
public class ApplicationController {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    MachineServiceImpl machineService;
    @Autowired
    JiGuangPushServiceImpl jiGuangPushService;
    @Autowired
    OrderTakingServiceImpl orderTakingService;
    @Autowired
    ShopServiceImpl shopService;
    @Autowired
    OrderServiceImpl orderService;
    @Autowired
    private ICustomerService customerService;

    @PostMapping("/saveData")
    public AjaxResult saveApplicationData(@RequestBody String body) {
        JSONObject bodyJson = JSONObject.parseObject(body);
        String machineCode = bodyJson.getString("machineCode");
        Integer screenNo = bodyJson.getInteger("screenNo");
        if (screenNo == null) {
            screenNo = 1;
        }
        String key = machineCode + "_" + screenNo;
        stringRedisTemplate.opsForValue().set(key, body);
        stringRedisTemplate.expire(key, 60, TimeUnit.SECONDS);
        return AjaxResult.success("处理成功", key);
    }

    @RequestMapping("/getData")
    public AjaxResult getApplicationData(@RequestBody String body) {
        JSONObject bodyJson = JSONObject.parseObject(body);
        String redisKey = bodyJson.getString("key");
        JSONObject location = bodyJson.getJSONObject("location");
        String redisVal = stringRedisTemplate.opsForValue().get(redisKey);
        if (StringUtils.isEmpty(redisVal)) {
            throw new ServiceException("该二维码已经过期");
        }

        String openId = bodyJson.getString("openId");
        String faceInfoId = bodyJson.getString("faceInfoId");
        if (StringUtils.isNotEmpty(openId)) {
            Assert.isTrue(StringUtils.isNotEmpty(faceInfoId), "faceInfoId还未传递");
            customerService.insertCustFaceInfo(openId, faceInfoId);
        }

        JSONObject redisJson = JSONObject.parseObject(redisVal);
        String machineCode = redisJson.getString("machineCode");
        Integer screenNo = redisJson.getInteger("screenNo");
        Machine machine = machineService.selectMachineByCode(machineCode);
        Shop shop = shopService.selectShopById(machine.getShopId());
        try {
            shop.setDistance(DistanceUtil.getDistanceDesc(Double.parseDouble(shop.getLng()), Double.parseDouble(shop.getLat()), Double.parseDouble(location.getString("lng")), Double.parseDouble(location.getString("lat"))));
        } catch (NumberFormatException e) {
            shop.setDistance("-1");
        }
        redisJson.put("shop", shop);
        //推送数据给安卓
        JSONObject jgBody = new JSONObject();
        jgBody.put("action", "QRCODE_VISITED");
        jgBody.put("timestamp", String.valueOf(System.currentTimeMillis()));
        JSONObject data = new JSONObject();
        data.put("seqNo", redisKey);
        jgBody.put("data", data);
        jiGuangPushService.push(Integer.parseInt(machine.getId()), screenNo, jgBody);
        // stringRedisTemplate.delete(redisKey);
        return AjaxResult.success("处理成功", redisJson.toJSONString());
    }

    @RequestMapping("/jgRegister")
    public AjaxResult jgRegister(@RequestParam String machineCode, @RequestParam(required = false) Integer screenNo, @RequestParam String registerId) {
        Machine machine = machineService.selectMachineByCode(machineCode);
        if (machine == null || machine.getShopId() == null) {
            throw new ServiceException("该机器未绑定店铺，请先绑定店铺");
        }

        if (screenNo == null) {
            screenNo = 1;
        }

        Assert.isTrue(StringUtils.isNotEmpty(machineCode), "machineCode不能为空");
        Assert.isTrue(StringUtils.isNotEmpty(registerId), "registerId不能为空");

//        machine.setRegister(registerId);
//        machineService.updateMachine(machine);
        machineService.saveMachineScreenRef(Integer.parseInt(machine.getId()), screenNo, registerId);
        return AjaxResult.success();
    }
    @RequestMapping("/getOrderTaking")
    public AjaxResult getOrderTaking(String machineCode){
        return AjaxResult.success(orderTakingService.getMachineInfo(machineCode));
    }

    @RequestMapping("/getOrderInfo")
    public AjaxResult getOrderInfo(String machineCode) {
        return AjaxResult.success(orderService.getOrderInfo(machineCode));
    }

    @RequestMapping("/checkSku")
    public AjaxResult checkSku(@RequestParam(required = false) Long shopId, Long skuId, @RequestParam(required = false) String machineCode) {
        return shopService.checkSku(shopId, skuId, machineCode);
    }
}
