package com.soss.common.enums;

public enum CouponCategoryType {
    DEDUCTION(1, "抵扣"),
    DISCOUNT(2, "折扣"),
    FREE(3, "免单");

    private Integer type;
    private String desc;

    CouponCategoryType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public static String getDesc(Integer type) {
        for (CouponCategoryType categoryType : CouponCategoryType.values()) {
            if (categoryType.type.equals(type)) {
                return categoryType.desc;
            }
        }
        return null;
    }
}
