package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * <p>
 * 优惠券类别
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
@Data
@NoArgsConstructor
public class CouponCategory extends BaseEntity {
    /**
     * 主键
     */
    private Integer id;

    /**
     * 优惠劵类别名
     */
    private String name;

    /**
     * 状态 0 默认 1 生效 2 下线 3删除
     */
    private Integer state;
    private String stateDesc;

    /**
     * 优惠券类别描述
     */
    private String desc;

    /**
     * 优惠券类型 1 抵扣 2 折扣 3 免单
     */
    private Integer type;
    private String typeDesc;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updatedAt;

    /**
     * 优惠券数量
     */
    private Long couponCnt;

    public CouponCategory(Integer id, Integer state) {
        this.id = id;
        this.state = state;
    }
}
