package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品对象 goods
 *
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class Goods extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private long id;

    /**
     * 商品名称
     */
    @Excel(name = "商品名称")
    private String name;

    /**
     * 商品分类
     */
    @Excel(name = "商品分类")
    private String category;

    @ApiModelProperty("商品类别id集合，与前端交互使用")
    private List<Long> categoryIds;

    private String categoryName;

    /**
     * 原售价
     */
    @Excel(name = "原售价")
    private BigDecimal price;

    /**
     * 折扣价
     */
    @Excel(name = "折扣价")
    private BigDecimal discount;

    /**
     * 特惠折扣价
     */
    @Excel(name = "特惠折扣价")
    private BigDecimal recommendPrice;

    /**
     * 特惠标签
     */
    @Excel(name = "特惠标签")
    private String recommendTag;
    /**
     * 特惠标签
     */
    @Excel(name = "特惠标签")
    private List<String> recommendTagList;

    /**
     * 制作用时 单位 秒
     */
    @Excel(name = "制作用时 单位 秒")
    private Long takeTime;

    /**
     * 规格信息 形如 [{“spec_name”:”规格1”,”其他属性”:”属性1”,”rules”:[“rule1_name”:”rule1”,”属性1”:”1111”]},{“spec_name”:”规格2”,”其他属性”:”属性2”,”rules”:[“rule1_name”:”rule2”,”属性2”:”2222”]}]
     */
    @Excel(name = "规格信息 形如 [{“spec_name”:”规格1”,”其他属性”:”属性1”,”rules”:[“rule1_name”:”rule1”,”属性1”:”1111”]},{“spec_name”:”规格2”,”其他属性”:”属性2”,”rules”:[“rule1_name”:”rule2”,”属性2”:”2222”]}]")
    private String spec;

    /**
     * 商品图片信息，json字符串形式 如 {“点单屏”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]},“小程序”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]}}
     */
    @Excel(name = "商品图片信息，json字符串形式 如 {“点单屏”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]},“小程序”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]}}")
    private String pics;

    /**
     * 描述
     */
    @Excel(name = "描述")
    private String desc;

    /**
     * 备注
     */
    @Excel(name = "备注")
    private String remarks;

    /** 商品状态 1 已创建
     2 已完成编程
     3 已上架
     4 已下架
     5 已删除
     */
    @Excel(name = "商品状态 1 正常 2 暂停")
    private String state;

    /** 0 正常 1 删除 */
    @Excel(name = "0 正常 1 删除")
    private Long isDeleted;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date shelfAt;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:dd")
    private Date recommendDate;

    /** 是否推荐 */
    private String recommend;

    /** 是否特惠 */
    private String preferential;

    /** 商品sku数量 */
    private Integer skuCount = 0;

    /** 商品售罄sku数量 */
    private Integer selloutCount = 0;

    /**
     * 总销量
     */
    private Integer salesVolume;

    /** 商品编码 */
    @Excel(name = "商品编码")
    private String code;

    /** 是否特惠商品 */
    private String isRecommend;

    private List<String> goodsTagList;

    public List<String> getGoodsTagList() {
        return goodsTagList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("category", getCategory())
            .append("price", getPrice())
            .append("discount", getDiscount())
            .append("takeTime", getTakeTime())
            .append("spec", getSpec())
            .append("pics", getPics())
            .append("desc", getDesc())
            .append("remarks", getRemarks())
            .append("state", getState())
            .append("isDeleted", getIsDeleted())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("code", getCode())
            .toString();
    }
}
