package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 订单退款对象 order_refund
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class OrderRefund extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 订单ID */
    @Excel(name = "订单ID")
    private Long orderId;

    /** 退款金额 */
    @Excel(name = "退款金额")
    private BigDecimal refundAmount;

    /** 订单退款状态 0 默认 1 退款中 2 退款成功 3 退款失败 */
    @Excel(name = "订单退款状态 0 默认 1 退款中 2 退款成功 3 退款失败")
    private Integer state;

    /** 退款原因等描述 */
    @Excel(name = "退款原因等描述")
    private String desc;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createdAt;

    private String createUserName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;
    private Order order;
    private String refundNo;

    private String orderNo;

    private BigDecimal totalFee;

    @ApiModelProperty("退款明细id集合")
    private List<Long> orderDetailIds;

    @ApiModelProperty("退款订单明细")
    private List<OrderDetail> orderDetails;

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("orderId", getOrderId())
                .append("refundAmount", getRefundAmount())
                .append("state", getState())
                .append("desc", getDesc())
                .append("createdAt", getCreatedAt())
                .append("updatedAt", getUpdatedAt())
                .toString();
    }
}
