package com.soss.system.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 反射工具类
 */
public class ReflectUtil {
    /**
     * 获取类的全部方法，以字典形式返回
     *
     * @param t
     * @param <T>
     * @return
     */
    public static <T> Map<String, Method> getMethod(T t) {
        Class tempClass = t.getClass();
        Map<String, Method> methodMap = new ConcurrentHashMap<>();
        while (tempClass != null) {
            Method[] declaredMethods = tempClass.getDeclaredMethods();
            for (Method method : declaredMethods) {
                if (!methodMap.containsKey(method.getName())) {
                    methodMap.put(method.getName(), method);
                }
            }
            tempClass = tempClass.getSuperclass();
        }
        return methodMap;
    }

    /**
     * 获取类的全部属性
     *
     * @param t
     * @param <T>
     * @return
     */
    public static <T> Map<String, Field> getFields(T t) {
        Class tempClass = t.getClass();
        Map<String, Field> fieldMap = new ConcurrentHashMap<>();
        while (tempClass != null) {
            Field[] declaredFields = tempClass.getDeclaredFields();
            for (Field field : declaredFields) {
                if (!fieldMap.containsKey(field.getName())) {
                    fieldMap.put(field.getName(), field);
                }
            }
            tempClass = tempClass.getSuperclass();
        }
        return fieldMap;
    }

    public static void accessField(Field... fields) {
        Arrays.stream(fields).forEach(field -> {
            if (field != null && !field.isAccessible()) {
                field.setAccessible(true);
            }
        });
    }
}
