package com.soss.common.enums;

public enum CouponUserType {
    RECEIVE(1, "领取"),
    GRANT(2, "发放"),
    GIVE(3, "赠送");

    private Integer type;
    private String desc;

    CouponUserType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public static String getDesc(Integer type) {
        for (CouponUserType couponUserStat : CouponUserType.values()) {
            if (couponUserStat.type.equals(type)) {
                return couponUserStat.desc;
            }
        }
        return null;
    }
}
