package com.soss.common.enums;

/**
 * sku删除状态枚举类
 */
public enum SkuDeleteState {
    NORMAL(0, "未删除"),
    DELETE_AUTO(1, "自动删除"),
    DELETE_MANUAL(2, "手动删除");

    private Integer state;
    private String desc;

    SkuDeleteState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (SkuDeleteState skuDeleteState : SkuDeleteState.values()) {
            if (skuDeleteState.state.equals(state)) {
                return skuDeleteState.desc;
            }
        }
        return null;
    }
}
