package com.soss.system.domain.po;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.exception.ServiceException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("优惠券请求类")
public class CouponPo {
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("优惠劵名")
    private String name;

    @ApiModelProperty("优惠券类别ID")
    private Integer categoryId;

    @ApiModelProperty("可用商品类别列表，全品类传 [0]")
    private Long[] categoryIds;

    @ApiModelProperty("可用商品id列表")
    private Long[] goodsIds;

    @ApiModelProperty("可用省份列表，全国通用传 [0]")
    private String[] province;

    @ApiModelProperty("可用城市列表")
    private String[] city;

    @ApiModelProperty("可用区域列表")
    private String[] area;

    @ApiModelProperty("可用店铺ID列表")
    private Long[] shopIds;

    @ApiModelProperty("可领取时间时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime receivableTime;

    @ApiModelProperty("使用绝对开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime useStartTime;

    @ApiModelProperty("使用绝对截止时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime useEndTime;

    @ApiModelProperty("领取后相对有效天数")
    private Integer relativeTime;

    @ApiModelProperty("价格扣减（当券类型为抵扣时单位为'元'，当券类型为折扣时，单位为'折'）")
    private BigDecimal priceDiscount;

    @ApiModelProperty("价格门槛，为0表示无门槛")
    private BigDecimal priceLimit;

    @ApiModelProperty("订单限制 false 整单 true 单杯")
    private Boolean orderLimit;

    @ApiModelProperty("周几限制 0表示不限 1-7表示周日到周六")
    private Integer[] weekLimit;

    @ApiModelProperty("用户可领取次数之次数限制0无限制，即每N天M次对应的次数")
    private Integer userLimit;

    @ApiModelProperty("用户可领取次数之天数限制0无限制，即每N天M次对应的天数")
    private Integer daysLimit;

    @ApiModelProperty("是否发送短信 false 不 true 发")
    private Boolean sendMsg;

    @ApiModelProperty("短信模板ID")
    private Integer msgId;

    public void couponUseAreaLimitCheck() {
        int limitDim = 0;
        if (province != null && province.length > 0) {
            limitDim += 1;
        }
        if (city != null && city.length > 0) {
            limitDim += 1;
        }
        if (area != null && area.length > 0) {
            limitDim += 1;
        }
        if (shopIds != null && shopIds.length > 0) {
            limitDim += 1;
        }
        if (limitDim == 0) {
            throw new ServiceException("适用范围之地区/门店还未传递");
        }
        if (limitDim > 1) {
            throw new ServiceException("适用范围之地区/门店不能跨级");
        }
    }
}
