package com.soss.system.mapper;

import com.soss.system.domain.Coupon;
import com.soss.system.domain.CouponCategory;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 优惠券 Mapper 接口
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
public interface CouponMapper {
    /**
     * 查询优惠券列表
     *
     * @param coupon
     * @return
     */
    List<Coupon> listCoupon(Coupon coupon);

    List<CouponCategory> getCouponCategoryTypeStat(@Param("categoryIds") List<Integer> categoryIds);

    /**
     * 新增优惠券
     *
     * @param coupon 优惠券
     * @return 结果
     */
    int insertCoupon(Coupon coupon);

    /**
     * 更新优惠券
     *
     * @param coupon 优惠券
     * @return 结果
     */
    int updateCoupon(Coupon coupon);

    /**
     * 获取优惠券详情
     *
     * @param id
     * @return
     */
    Coupon selectCouponById(Integer id);

    /**
     * 获取当前有效的规则集合
     *
     * @return
     */
    List<Coupon> getEffectiveCoupon();

    /**
     * 到期的优惠券状态置为失效
     */
    void expireCoupon();
}
