package com.soss.system.mapper;

import com.soss.system.domain.Machine;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 机器Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface MachineMapper 
{
    /**
     * 查询机器
     *
     * @param id 机器主键
     * @return 机器
     */
    public Machine selectMachineById(String id);

    List<Machine> selectMachineByShopId(Long shopId);


    public Machine selectMachineByCode(String code);
    /**
     * 查询机器列表
     * 
     * @param machine 机器
     * @return 机器集合
     */
    public List<Machine> selectMachineList(Machine machine);

    /**
     * 新增机器
     * 
     * @param machine 机器
     * @return 结果
     */
    public int insertMachine(Machine machine);

    /**
     * 修改机器
     * 
     * @param machine 机器
     * @return 结果
     */
    public int updateMachine(Machine machine);

    /**
     * 删除机器
     * 
     * @param id 机器主键
     * @return 结果
     */
    public int deleteMachineById(String id);

    /**
     * 批量删除机器
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMachineByIds(String[] ids);

    int unbound(String id);

//    String selectRegister(String id);

    void saveMachineScreenRef(@Param("machineId") Integer machineId, @Param("screenNo") Integer screenNo, @Param("registerId") String registerId);

    String[] selectRegister(@Param("machineId") Integer machineId, @Param("screenNo") Integer screenNo);
}
