package com.soss.system.mapper;

import com.soss.system.domain.OrderDetail;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 订单详情Mapper接口
 *
 * @author zxq
 * @date 2022-04-28
 */
public interface OrderDetailMapper {
    /**
     * 查询订单详情
     *
     * @param id 订单详情主键
     * @return 订单详情
     */
    public OrderDetail selectOrderDetailById(String id);

    List<OrderDetail> selectOrderDetailsByIds(@Param("ids") List<Long> ids);

    /**
     * 根据明细id集合查询明细列表
     *
     * @param ids
     * @return
     */
    List<OrderDetail> listDetailByIds(@Param("ids") List<Long> ids);

    /**
     * 查询订单详情列表
     *
     * @param orderDetail 订单详情
     * @return 订单详情集合
     */
    public List<OrderDetail> selectOrderDetailList(OrderDetail orderDetail);

    /**
     * 新增订单详情
     *
     * @param orderDetail 订单详情
     * @return 结果
     */
    public int insertOrderDetail(OrderDetail orderDetail);

    /**
     * 批量插入
     */
    int insertBatch(@Param("details") List<OrderDetail> details);

    /**
     * 修改订单详情
     *
     * @param orderDetail 订单详情
     * @return 结果
     */
    public int updateOrderDetail(OrderDetail orderDetail);

    /**
     * 删除订单详情
     * 
     * @param id 订单详情主键
     * @return 结果
     */
    public int deleteOrderDetailById(String id);

    /**
     * 批量删除订单详情
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteOrderDetailByIds(String[] ids);

    void bindRefund(@Param("refundId") Long refundId, @Param("ids") List<Long> ids);

    void updateRefundState(@Param("refundId") Long refundId, @Param("refundTime") Date refundTime);

    /**
     * 查询店铺商品销量
     */
    List<OrderDetail> selectGoodsSalesVolume(@Param("shopId") Long shopId, @Param("goodsIds") List<Long> goodsIds);
}
