package com.soss.system.schedule;

import com.soss.system.constants.OrderStatusConstant;
import com.soss.system.domain.Order;
import com.soss.system.domain.OrderOperationLog;
import com.soss.system.mapper.OrderMapper;
import com.soss.system.mapper.OrderOperationLogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
public class OrderSchedule {
    @Autowired
    private OrderMapper orderMapper;
//    @Value("${timeout}")
//    private Integer timeout;
    @Autowired
    private OrderOperationLogMapper operationLogMapper;
//    @Autowired
//    private OrderServiceImpl orderService;

    @Scheduled(fixedDelay = 60*1000)
    private void process() {
        //orderMapper.updateTimeOut(OrderStatusConstant.productionCompleted,timeout);
        /*List<Order> orders1 = orderMapper.selectOrderByTime(OrderStatusConstant.productionCompleted, timeout);
        if(orders1!=null &&orders1.size()>0){
            for (Order order : orders1) {
                order.setState(OrderStatusConstant.timeout);
                order.setUpdatedAt(new Date());
                orderService.updateOrder(order);
            }
        }*/
        //orderMapper.updateCancel(OrderStatusConstant.Unpaid,15);
        List<Order> orders = orderMapper.selectOrderByTime(OrderStatusConstant.Unpaid, 15*60);
        if(orders!=null &&orders.size()>0){
            for (Order order : orders) {
                order.setState(OrderStatusConstant.UnpaidCancel);
                order.setUpdatedAt(new Date());
                orderMapper.updateOrder(order);
                OrderOperationLog operationLog =new OrderOperationLog();
                operationLog.setOperationUser("系统");
                operationLog.setStatus("已取消");
                operationLog.setOrderId(order.getId());
                operationLog.setContent("超时自动取消");
                operationLog.setCreateAt(new Date());
                operationLog.setOperation("取消订单");
                operationLogMapper.insertOrderOperationLog(operationLog);
            }
        }
    }

}
