package com.soss.system.service;

import com.soss.system.domain.Goods;
import com.soss.system.domain.GoodsSku;
import com.soss.system.domain.Order;

import java.util.List;

/**
 * 商品Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IGoodsService 
{
    /**
     * 查询商品
     * 
     * @param id 商品主键
     * @return 商品
     */
    public Goods selectGoodsById(Long id);

    List<Goods> selectGoodsByIds(List<Long> ids);

    /**
     * 查询商品列表
     * 
     * @param goods 商品
     * @return 商品集合
     */
    public List<Goods> selectGoodsList(Goods goods);

    void resolverGoodsVolume(Long shopId, List<Goods> goodsList);

    void resolverCategoryName(List<Goods> goodsList);

    /**
     * 新增商品
     * 
     * @param goods 商品
     * @return 结果
     */
    public int insertGoods(Goods goods);

    /**
     * 修改商品
     * 
     * @param goods 商品
     * @return 结果
     */
    public int updateGoods(Goods goods);

    /**
     * 批量删除商品
     * 
     * @param ids 需要删除的商品主键集合
     * @return 结果
     */
    public int deleteGoodsByIds(String[] ids);

    /**
     * 删除商品信息
     * 
     * @param id 商品主键
     * @return 结果
     */
    public int deleteGoodsById(String id);

    String putShop(Long goodsId, boolean boo);

    String offShop(Long goodsId, boolean boo);

    String deleteGoodsById(Long goodsId, boolean boo);

    List<GoodsSku> getGoodsSkus(long goodsId);

    void resolverGoodsOfOrder(Order order);
}
