package com.soss.system.service.impl;

import com.soss.system.domain.Machine;
import com.soss.system.domain.ShopGoods;
import com.soss.system.domain.ShopGoodsSku;
import com.soss.system.mapper.*;
import com.soss.system.service.IShopGoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 店铺和商品关联Service业务层处理
 *
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class ShopGoodsServiceImpl implements IShopGoodsService {
    @Autowired
    private ShopGoodsMapper shopGoodsMapper;
    @Autowired
    private ShopGoodsSkuMapper shopGoodsSkuMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private SpecMapper specMapper;
    @Autowired
    private MachineMapper machineMapper;
    @Autowired
    private MachineApiServiceImpl machineApiService;

    /**
     * 查询店铺和商品关联
     *
     * @param id 店铺和商品关联主键
     * @return 店铺和商品关联
     */
    @Override
    public ShopGoods selectShopGoodsById(String id) {
        return shopGoodsMapper.selectShopGoodsById(id);
    }

    /**
     * 查询店铺和商品关联列表
     *
     * @param shopGoods 店铺和商品关联
     * @return 店铺和商品关联
     */
    @Override
    public List<ShopGoods> selectShopGoodsList(ShopGoods shopGoods) {
        return shopGoodsMapper.selectShopGoodsList(shopGoods);
    }

    /**
     * 新增店铺和商品关联
     *
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    @Override
    public int insertShopGoods(ShopGoods shopGoods) {
        return shopGoodsMapper.insertShopGoods(shopGoods);
    }

    /**
     * 修改店铺和商品关联
     *
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    @Override
    public int updateShopGoods(ShopGoods shopGoods) {
        return shopGoodsMapper.updateShopGoods(shopGoods);
    }

    /**
     * 批量删除店铺和商品关联
     *
     * @param ids 需要删除的店铺和商品关联主键
     * @return 结果
     */
    @Override
    public int deleteShopGoodsByIds(String[] ids) {
        return shopGoodsMapper.deleteShopGoodsByIds(ids);
    }

    /**
     * 删除店铺和商品关联信息
     *
     * @param id 店铺和商品关联主键
     * @return 结果
     */
    @Override
    public int deleteShopGoodsById(String id) {
        return shopGoodsMapper.deleteShopGoodsById(id);
    }

    @Override
    public List<ShopGoodsSku> selectSkuByShopGoods(Long shopId, Long goodsId) {
        List<ShopGoodsSku> skus = shopGoodsSkuMapper.selectSkuByShopGoods(shopId, goodsId);
        return skus;
    }

    @Override
    public Boolean updateShopGoodsSkuState(Long shopId, Long goodsId, List<Long> shopGoodsSkuIds, Integer state) {
//        int i = shopGoodsSkuMapper.updateShopGoodsSkuState(shopGoodsSkuId, state);
//        if (i > 0) {
//            return true;
//        }

        for (Long id : shopGoodsSkuIds) {
            shopGoodsSkuMapper.updateShopGoodsSkuState(id, state);
        }

        List<Long> skuIds = shopGoodsSkuMapper.selectSkuIds(shopGoodsSkuIds);
        if(!CollectionUtils.isEmpty(skuIds)) {
            //推送给极光
            List<Machine> machines = machineMapper.selectMachineByShopId(shopId);
            if (CollectionUtils.isEmpty(machines)) {
                return true;
            }

            Machine machine = machines.get(0);
            Map<Long, List<Long>> map = new HashMap<>();
            map.put(goodsId, skuIds);
            machineApiService.push(machine, String.valueOf(state), map);
        }
        return true;
    }
}
