package com.soss.system.weixin.util;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.soss.common.utils.DateUtils;
import com.soss.system.domain.Order;
import com.soss.system.domain.Shop;
import com.soss.system.mapper.ShopMapper;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class SendMessageUtils {
    @Autowired
    private WxMaService wxMaService;
    @Value("${weixin.pagePath}")
    private String pagePath;
    @Value("${weixin.program}")
    private String program;
    @Autowired
    private ShopMapper shopMapper;

    private Map<Integer, JSONObject> templateMap;

    @PostConstruct
    public void init() {
        templateMap = new HashMap<>();
        JSONObject ordSuc = new JSONObject();
        ordSuc.put("templateId", "1uErx-15S-3vuopXSvvsxCeM_Jd-1iZC-nXzd2yW3QU");
        JSONObject ordSucParam = new JSONObject();
        ordSucParam.put("character_string1", "$.orderNum");
        ordSucParam.put("thing2", "$.shop.name");
        ordSucParam.put("thing12", "$.shop.address");
        ordSucParam.put("time7", "now");
        ordSucParam.put("thing6", "您的订单已经下单成功了~");
        ordSuc.put("param", ordSucParam);
        templateMap.put(2, ordSuc);

        JSONObject making = new JSONObject();
        making.put("templateId", "Q4HDwBEvpTXpwtZktqWm4SZOTEuQK1x48xjqjD2GqyM");
        JSONObject makingParam = new JSONObject();
        makingParam.put("thing1", "$.shop.name");
        makingParam.put("date6", "now");
        makingParam.put("thing5", "订单已经开始制作，即将可以享用美食!");
        making.put("param", makingParam);
        templateMap.put(3, making);

        JSONObject untake = new JSONObject();
        untake.put("templateId", "Fu_CPIXa0cnJ4EDdVKqFQ3qqKJccMqt2oorI5mfNq74");
        JSONObject untakeParam = new JSONObject();
        untakeParam.put("character_string4", "$.orderNum");
        untakeParam.put("thing2", "$.shop.name");
        untakeParam.put("thing7", "$.shop.address");
        untakeParam.put("time6", "now");
        untakeParam.put("thing11", "您的订单制作完成了，现在可以去取餐啦！");
        untake.put("param", untakeParam);
        templateMap.put(4, untake);

        JSONObject complete = new JSONObject();
        complete.put("templateId", "Oq_zfRWRXijvXenRmfD2PARgpvdYlbkjR4laxKmBqb0");
        JSONObject completeParam = new JSONObject();
        completeParam.put("character_string10.DATA", "$.orderNum");
        completeParam.put("thing1.DATA", "$.shop.name");
        completeParam.put("date7.DATA", "now");
        completeParam.put("thing11", "您的订单制作完成了，现在可以去取餐啦！");
        complete.put("param", completeParam);
        templateMap.put(6, complete);

        JSONObject timeout = new JSONObject();
        timeout.put("templateId", "Q4HDwBEvpTXpwtZktqWm4SZOTEuQK1x48xjqjD2GqyM");
        JSONObject timeoutParam = new JSONObject();
        timeoutParam.put("thing1", "$.shop.name");
        timeoutParam.put("date6", "now");
        timeoutParam.put("thing5", "取餐超时，已将出品废弃，请联系客服重做~");
        timeout.put("param", timeoutParam);
        templateMap.put(7, timeout);
    }

    /**
     * 根据模板id发送消息
     */
    public void sendWxMsg(Order order) {
        Integer orderState = Integer.parseInt(order.getState());
        JSONObject orderTemplate = templateMap.get(orderState);
        if (orderTemplate == null) {
            return;
        }

        Shop shop = shopMapper.selectShopById(order.getShopId());
        order.setShop(shop);

        JSONObject params = orderTemplate.getJSONObject("param");
        List<WxMaSubscribeMessage.MsgData> dataList = new ArrayList<>();
        params.forEach((key, value) -> {
            WxMaSubscribeMessage.MsgData data = new WxMaSubscribeMessage.MsgData();
            dataList.add(data);
            String valueString = (String) value;
            data.setName(key);
            if ("now".equals(valueString)) {
                valueString = DateUtils.getTime();
            } else if (valueString.startsWith("$")) {
                valueString = (String) JSONPath.eval(order, valueString);
            }
            data.setValue(valueString);
        });

        WxMaSubscribeMessage.WxMaSubscribeMessageBuilder builder = WxMaSubscribeMessage.builder();
        //发送人openid
        builder.toUser(order.getUserId());
        //发送的模板id
        builder.templateId(orderTemplate.getString("templateId"));
        //消息主体
        builder.data(dataList);
        //点击订阅消息的跳转链接（默认是正式发布的小程序页面，当然也可以通过参数进行控制）
        builder.page(pagePath + order.getId());
        builder.miniprogramState(program);
        WxMaSubscribeMessage msg = builder.build();
        try {
            wxMaService.getMsgService().sendSubscribeMsg(msg);
        } catch (WxErrorException e) {
            log.error("订阅消息发送失败，用户openId:{}, 错误码：{},错误信息：{}",
                    order.getUserId(), e.getError().getErrorCode(), e.getError().getErrorMsg());
            //发送失败就发送短信
        }
    }
}
