package com.soss.web.controller.coffee;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.exception.ServiceException;
import com.soss.framework.web.service.TokenService;
import com.soss.system.domain.Order;
import com.soss.system.domain.OrderDetail;
import com.soss.system.service.impl.AppServiceImpl;
import com.soss.system.service.impl.OrderServiceImpl;
import com.soss.system.service.impl.WechatMessageServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/app")
public class AppController extends BaseController {
    @Autowired
    private TokenService tokenService;
    @Autowired
    private AppServiceImpl appService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private WechatMessageServiceImpl wechatMessageService;



    @RequestMapping("/getMyOrder")
    public TableDataInfo getMyOrder(HttpServletRequest request){
        LoginUser loginUser = tokenService.getLoginUser(request);
        if(loginUser ==null){
          throw new ServiceException("请先登录");
        }
        String openId = loginUser.getOpenId();
        startPage();
        List<Order> myOrder = orderService.getMyOrder(openId);
        return getDataTable(myOrder);
    }

    @RequestMapping("/getHomeOrder")
    public AjaxResult getHomeOrder(HttpServletRequest request){
        LoginUser loginUser = tokenService.getLoginUser(request);
        if(loginUser ==null){
            return  AjaxResult.success();
        }
        String openId = loginUser.getOpenId();
        Map<String,String> info = orderService.getMyFristOrder(openId);
        return AjaxResult.success("操作成功",info);
    }
    @RequestMapping("/getWaitTine")
    public AjaxResult getWaitTime(@RequestBody String body){
        JSONObject jsonObject = JSONObject.parseObject(body);
        Order order = new Order();
        order.setShopId(jsonObject.getString("shopId"));
        JSONArray goods = jsonObject.getJSONArray("goods");
        List<OrderDetail> orderDetails = new ArrayList<>();
        order.setOrderDetails(orderDetails);
        for(int i =0;i<goods.size();i++){
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setGoodsId(goods.getJSONObject(i).getString("goodsId"));
            orderDetail.setNum(goods.getJSONObject(i).getString("num"));
            orderDetails.add(orderDetail);

        }
        String info = orderService.getWaitTime(order);
        return AjaxResult.success("操作成功",info);
    }



    @RequestMapping("/refundOrder")
    public AjaxResult refundOrder(String orderId){
        return AjaxResult.success(orderService.refundOrder(orderId));
    }
    @RequestMapping("/getNextOrder")
    public AjaxResult getNextOrder(String orderId,String shopId){
        return AjaxResult.success(orderService.getNextOrder(orderId,shopId));
    }
    @RequestMapping("/getMessageCount")
    public AjaxResult getMessageCount(HttpServletRequest request){
        LoginUser loginUser = tokenService.getLoginUser(request);
        return AjaxResult.success("",wechatMessageService.getMessageCount(loginUser.getOpenId()));
    }

}
