package com.soss.web.controller.coffee;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.StringUtils;
import com.soss.common.utils.uuid.UUID;
import com.soss.system.domain.Machine;
import com.soss.system.domain.Shop;
import com.soss.system.jiguang.impl.JiGuangPushServiceImpl;
import com.soss.system.service.impl.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

@RestController
@RequestMapping("/application")
public class ApplicationController {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
     MachineServiceImpl machineService;
    @Autowired
    JiGuangPushServiceImpl jiGuangPushService;
    @Autowired
     OrderTakingServiceImpl orderTakingService;
    @Autowired
     ShopServiceImpl shopService;
    @Autowired
     OrderServiceImpl orderService;
    @RequestMapping("/saveData")
    public AjaxResult saveApplicationData(@RequestParam("machineCode")String machineCode, @RequestBody String body){
        String id = UUID.randomUUID().toString();
        String key = machineCode;//+"_"+id;
        stringRedisTemplate.opsForValue().set(key, body);
        stringRedisTemplate.expire(key,60, TimeUnit.SECONDS);
        return AjaxResult.success("处理成功",key);
    }
    @RequestMapping("/getData")
    public AjaxResult getApplicationData(@RequestBody String body){
        JSONObject jj = JSONObject.parseObject(body);
        String key = jj.getString("key");
        JSONObject location = jj.getJSONObject("location");
        String s = stringRedisTemplate.opsForValue().get(key);
        if(StringUtils.isEmpty(s)){
            throw new ServiceException("该二维码已经过期");
        }
        JSONObject info = JSONObject.parseObject(s);
        String machineCode = info.getString("machineCode");
        Machine machine = machineService.selectMachineByCode(machineCode);
        Shop shop = shopService.selectShopById(String.valueOf(machine.getShopId()));
        shop.setDistance(AppServiceImpl.GetDistance(Double.parseDouble(shop.getLng()),Double.parseDouble(shop.getLat()),Double.parseDouble(location.getString("lng")),Double.parseDouble(location.getString("lat"))));
        info.put("shop",shop);
        String[] keys = key.split("_");
        //推送数据给安卓
        JSONObject jsonObject  = new JSONObject();
        jsonObject.put("action","QRCODE_VISITED");
        jsonObject.put("timestamp",String.valueOf(System.currentTimeMillis()));
        JSONObject data = new JSONObject();
        data.put("seqNo",key);
        jsonObject.put("data",data);
        jiGuangPushService.push(keys[0],jsonObject);
       // stringRedisTemplate.delete(key);
        return AjaxResult.success("处理成功",info.toJSONString());
    }
    @RequestMapping("/jgRegister")
    public AjaxResult jgRegister(@RequestParam String machineCode,@RequestParam String registerId){
        Machine machine = machineService.selectMachineByCode(machineCode);
        if(machine==null ){
            throw new ServiceException("该机器未绑定店铺，请先绑定店铺");
        }

        machine.setRegister(registerId);
        return AjaxResult.success(machineService.updateMachine(machine));
    }
    @RequestMapping("/getOrderTaking")
    public AjaxResult getOrderTaking(String machineCode){
        return AjaxResult.success(orderTakingService.getMachineInfo(machineCode));
    }

    @RequestMapping("/getOrderInfo")
    public AjaxResult getOrderInfo(String machineCode){
        return AjaxResult.success(orderService.getOrderInfo(machineCode));
    }
    @RequestMapping("/checkSku")
    public AjaxResult checkSku(@RequestParam(required = false) String shopId,String skuId,@RequestParam(required = false) String machineCode){
        return shopService.checkSku(shopId,skuId,machineCode);
    }
}
