package com.soss.web.controller.coffee;

import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.enums.BusinessType;
import com.soss.common.utils.poi.ExcelUtil;
import com.soss.common.utils.spring.SpringUtils;
import com.soss.framework.web.service.TokenService;
import com.soss.system.domain.Customer;
import com.soss.system.domain.Order;
import com.soss.system.domain.vo.customer.CustomerQueryVo;
import com.soss.system.domain.vo.customer.CustomerResultVo;
import com.soss.system.service.ICustomerService;
import com.soss.system.service.impl.CustomerServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 用户信息Controller
 * 
 * @author zxq
 * @date 2022-05-01
 */
@RestController
@RequestMapping("/system/customer")
public class CustomerController extends BaseController
{
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private TokenService tokenService;


    @GetMapping("/allow")
    public AjaxResult allow(HttpServletRequest request,String allow){
        TokenService bean = SpringUtils.getBean(TokenService.class);
        LoginUser loginUser = bean.getLoginUser(request);

        return AjaxResult.success(SpringUtils.getBean(CustomerServiceImpl.class).allow(loginUser.getOpenId(),allow));
    }

    /**
     * 查询用户信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:customer:list')")
    @GetMapping("/list")
    public TableDataInfo list(CustomerQueryVo customerQueryVo)
    {
        startPage();
        List<CustomerResultVo> list = customerService.selectCustomerList(customerQueryVo);
        return getDataTable(list);
    }



    /**
     * 获取用户信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:customer:query')")
    @GetMapping
    public TableDataInfo getInfo(@RequestParam("id") String id,@RequestParam String status)
    {
        startPage();
        List<Order> orders = customerService.selectCustomerById(id,status);
        return getDataTable(orders);
    }



}
