package com.soss.web.controller.coffee;

import java.util.List;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.Goods;
import com.soss.system.service.IGoodsService;
import com.soss.common.core.page.TableDataInfo;

/**
 * 商品Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/goods")
public class GoodsController extends BaseController
{
    @Autowired
    private IGoodsService goodsService;

    /**
     * 查询商品列表
     */
    @PreAuthorize("@ss.hasPermi('system:goods:list')")
    @GetMapping("/list")
    public TableDataInfo list(Goods goods)
    {
        startPage();
        List<Goods> list = goodsService.selectGoodsList(goods);
        return getDataTable(list);
    }

    /**
     * 是否全部上架
     * @param goodsId
     * @param boo
     * @return
     */
    @GetMapping("/putShop")
    public AjaxResult  putShop(@RequestParam("goodsId") Long goodsId, @RequestParam("boo") boolean boo){
        return AjaxResult.success(goodsService.putShop(goodsId,boo));
    }

    /**
     * 下架
     * @param goodsId
     * @param boo
     * @return
     */
    @GetMapping("/offShop")
    public AjaxResult offShop(@RequestParam("goodsId") Long goodsId,@RequestParam(required = false) boolean boo){
        return AjaxResult.success(goodsService.offShop(goodsId,boo));
    }




    /**
     * 获取商品详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:goods:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(goodsService.selectGoodsById(id));
    }

    /**
     * 新增商品
     */
    @PreAuthorize("@ss.hasPermi('system:goods:add')")
    @Log(title = "商品", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Goods goods)
    {
        return toAjax(goodsService.insertGoods(goods));
    }

    /**
     * 修改商品
     */
    @PreAuthorize("@ss.hasPermi('system:goods:edit')")
    @Log(title = "商品", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Goods goods)
    {
        return toAjax(goodsService.updateGoods(goods));
    }

    /**
     * 删除商品
     */
    @PreAuthorize("@ss.hasPermi('system:goods:remove')")
    @Log(title = "商品", businessType = BusinessType.DELETE)
	@DeleteMapping("/remove")
    public AjaxResult remove(@RequestParam("goodsId") Long goodsId,@RequestParam(required = false) boolean boo)
    {
        return AjaxResult.success(goodsService.deleteGoodsById(goodsId,boo));
    }

}
