package com.soss.web.controller.coffee;

import com.alibaba.fastjson.JSONObject;
import com.soss.system.domain.vo.ResultVo;
import com.soss.system.service.impl.MachineApiServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/v1")
@Slf4j
public class MachineApiController {
    @Autowired
    private MachineApiServiceImpl machineApiService;
    @PostMapping("/down/material/update")
    public ResultVo shopGoodsUpdate(@RequestBody String body){
        log.info("/down/material/update 请求内容为 【{}】",body);
        JSONObject jsonObject = JSONObject.parseObject(body);
        try{
            return ResultVo.success(machineApiService.shopGoodsUpdate(jsonObject));
        }catch (Exception e){
            return ResultVo.error(e.getMessage());
        }
    }
    @PostMapping("/down/order/update")
    public ResultVo updateOrder(@RequestBody String body){
        log.info("/down/order/update 请求内容为 【{}】",body);
        JSONObject jsonObject = JSONObject.parseObject(body);
        try{
            return ResultVo.success(machineApiService.updateOrder(jsonObject));
        }catch (Exception e){
            return ResultVo.error(e.getMessage());
        }

    }
    @PostMapping("/down/robot/status")
    public ResultVo robotUpdate(@RequestBody String body){
        log.info("/down/robot/status 请求内容为 【{}】",body);
        JSONObject jsonObject = JSONObject.parseObject(body);
        try{
            return ResultVo.success(machineApiService.robotUpdate(jsonObject));
        }catch (Exception e){
            return ResultVo.error(e.getMessage());
        }
    }
    @PostMapping("/down/order/check")
    public ResultVo checkOrder(@RequestBody String body){
        log.info("/down/order/check 请求内容为 【{}】",body);
        JSONObject jsonObject = JSONObject.parseObject(body);
        try{
            return ResultVo.success(machineApiService.checkOrder(jsonObject));
        }catch (Exception e){
            return ResultVo.error(e.getMessage());
        }

    }
    @GetMapping("/testOrder")
    public void testOrder(String orderId){
        machineApiService.testOrder(orderId);
    }
    @GetMapping("/testOrderUpdate")
    public void testOrderUpdate(String orderId){
        machineApiService.testOrderUpdate(orderId);
    }
}
