package com.soss.web.controller.coffee;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

import com.soss.common.constant.HttpStatus;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.common.exception.ServiceException;
import com.soss.framework.web.service.TokenService;
import com.soss.framework.web.service.WeixinServiceImpl;
import com.soss.system.domain.vo.OrderQuery;
import com.soss.system.service.impl.CustomerServiceImpl;
import com.soss.system.service.impl.OrderServiceImpl;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.Order;
import com.soss.system.service.IOrderService;
import com.soss.common.core.page.TableDataInfo;

/**
 * 订单Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/order")
public class OrderController extends BaseController
{
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private WeixinServiceImpl weixinService;

    /**
     * 查询订单列表
     */
    @PreAuthorize("@ss.hasPermi('system:order:list')")
    @GetMapping("/list")
    public TableDataInfo list(OrderQuery orderQuery)
    {
        startPage();
        List<Order> list = orderService.selectOrderList(orderQuery);
        return getDataTable(list);
    }





    /**
     * 获取订单详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:order:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(orderService.selectOrderById(id));
    }


    @PostMapping("/check")
    public AjaxResult check(@RequestBody Order order)
    {
        return orderService.check(order);
    }

    /**
     * 新增订单
     */
    @Log(title = "订单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(HttpServletRequest request, @RequestBody Order order)
    {
        LoginUser loginUser = tokenService.getLoginUser(request);

        AjaxResult ajaxResult =  orderService.insertOrder(loginUser,order);
        if(HttpStatus.SUCCESS != (int)ajaxResult.get(AjaxResult.CODE_TAG)){
           return ajaxResult;
        }
        int amount = order.getAmount().movePointRight(2).intValue();
        Map payInfo = weixinService.pay(request, "hooloo", order.getOrderNo(), order.getUserId(), amount);
        if(payInfo !=null){
            return AjaxResult.success(payInfo);
        }else{
            throw new ServiceException("微信支付发生异常");
        }
    }
    @RequestMapping("/payOrder")
    public AjaxResult cancel(HttpServletRequest request, String orderId)
    {
        Order order = orderService.selectOrderById(orderId);
        order.setOrderNo(orderService.getOrderNo(order.getSource()));
        orderService.updateOrder(order);
        int amount = order.getAmount().movePointRight(2).intValue();
        Map payInfo = weixinService.pay(request, "hooloo", order.getOrderNo(), order.getUserId(), amount);
        if(payInfo !=null){
            return AjaxResult.success(payInfo);
        }else{
            throw new ServiceException("微信支付发生异常");
        }
    }


    /**
     * 修改订单
     */
    @PreAuthorize("@ss.hasPermi('system:order:edit')")
    @Log(title = "订单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Order order)
    {
        return toAjax(orderService.updateOrder(order));
    }
    @RequestMapping("/cancel")
    public AjaxResult cancel(String orderId)
    {
        return toAjax(orderService.cancel(orderId));
    }

}
