package com.soss.web.controller.coffee;

import java.util.List;

import com.soss.system.domain.OrderOperationLog;
import com.soss.system.service.IOrderOperationLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;

/**
 * 订单日志Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/log")
public class OrderLogController extends BaseController
{
    @Autowired
    private IOrderOperationLogService orderLogService;

    /**
     * 查询订单日志列表
     */

    @GetMapping("/list")
    public AjaxResult list(String orderId)
    {
        OrderOperationLog orderOperationLog = new OrderOperationLog();
        orderOperationLog.setOrderId(orderId);
        List<OrderOperationLog> orderOperationLogs = orderLogService.selectOrderOperationLogList(orderOperationLog);
        return AjaxResult.success(orderOperationLogs);
    }


}
