package com.soss.web.controller.coffee;

import com.soss.common.core.domain.AjaxResult;
import com.soss.system.service.impl.OrderTakingServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 点单信息
 */
@RestController
@RequestMapping(("/orderTaking"))
public class OrderTakingController {
    @Autowired
    private OrderTakingServiceImpl orderTakingService;

    /**
     * 通过机器编码获取点单屏信息
     * @param machineCode
     * @return
     */
    @GetMapping(value = "/infoByMachine")
    public AjaxResult infoByMachine(String machineCode)
    {
        return AjaxResult.success(orderTakingService.getMachineInfo(machineCode));
    }
    /**
     * 通过店铺id获取点单屏信息
     * @param
     * @return
     */
    @GetMapping(value = "/infoByShop")
    public AjaxResult infoByShop(String shopId)
    {
        return AjaxResult.success(orderTakingService.getInfoByShop(shopId));
    }


}
