package com.soss.web.controller.coffee;

import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.soss.system.domain.Goods;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.Shop;
import com.soss.system.service.IShopService;
import com.soss.common.core.page.TableDataInfo;

/**
 * 店铺Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/shop")
public class ShopController extends BaseController
{
    @Autowired
    private IShopService shopService;

    @GetMapping(value = "/turn")
    public AjaxResult turn(@RequestParam Long shopId,@RequestParam Long goodsId, @RequestParam String pointer){
        return AjaxResult.success(shopService.turn(shopId,goodsId,pointer));
    }




    /**
     * 查询店铺列表
     */
    @GetMapping("/list")
    public TableDataInfo list(Shop shop)
    {
        startPage();
        List<Shop> list = shopService.selectShopList(shop);
        return getDataTable(list);
    }

    /**
     * 获取店铺详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:shop:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(shopService.selectShopById(id));
    }



    /**
     * 新增店铺
     */
    @PreAuthorize("@ss.hasPermi('system:shop:add')")
    @Log(title = "店铺", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Shop shop)
    {
        return AjaxResult.success(shopService.insertShop(shop));
    }

    /**
     * 修改店铺
     */
    @PreAuthorize("@ss.hasPermi('system:shop:edit')")
    @Log(title = "店铺", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Shop shop)
    {
        return toAjax(shopService.updateShop(shop));
    }

    /**
     * 删除店铺
     */
    @PreAuthorize("@ss.hasPermi('system:shop:remove')")
    @Log(title = "店铺", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(shopService.deleteShopByIds(ids));
    }

    /**
     * 给店铺增加商品
     */
    @PreAuthorize("@ss.hasPermi('system:shop:addGoods')")
    @GetMapping(value = "/addGoods")
    public AjaxResult addGoods(Long shopId,String goodsIds)
    {
        return AjaxResult.success(shopService.addGoods(shopId,goodsIds));
    }
    @PostMapping(value = "/offGoods")
    public AjaxResult offGoods(@RequestBody String body)
    {
        JSONObject jsonObject = JSON.parseObject(body);
        return AjaxResult.success(shopService.offGoods(jsonObject));
    }
    /**
     * 获取店铺里面的商品信息，分类展示
     */

    @GetMapping(value = "/getCategoryGoods")
    public AjaxResult getCategoryGoods(long shopId)
    {
        return AjaxResult.success(shopService.getCategoryGoods(shopId));
    }
    /**
     * 获取店铺里面商品对应的产品信息
     */
    @GetMapping(value = "/getSkuByGoodsId")
    public AjaxResult getSkuByGoodsId(long shopId,long goodsId)
    {
        return AjaxResult.success(shopService.getSkuByGoodsId(shopId,goodsId));
    }

    /**
     * 获取有店铺的城市
     * @return
     */
    @GetMapping("/getShopCity")
    public AjaxResult getShopCity(){
        return AjaxResult.success(shopService.getShopCity());

    }
    @GetMapping("/goodslist")
    public TableDataInfo list(String goodsName,String category,Long shopId)
    {
        startPage();
        List<Goods> list = shopService.selectGoodsList(goodsName,category,shopId);
        return getDataTable(list);
    }


}
