package com.soss.web.controller.coffee;

import java.util.List;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.Spec;
import com.soss.system.service.ISpecService;
import com.soss.common.core.page.TableDataInfo;

/**
 * 规格Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/spec")
public class SpecController extends BaseController
{
    @Autowired
    private ISpecService specService;

    /**
     * 查询规格列表
     */
  //  @PreAuthorize("@ss.hasPermi('system:spec:list')")
    @GetMapping("/list")
    public TableDataInfo list(Spec spec)
    {
        startPage();
        List<Spec> list = specService.selectSpecList(spec);
        return getDataTable(list);
    }



    /**
     * 获取规格详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:spec:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(specService.selectSpecById(id));
    }

    /**
     * 新增规格
     */
    @PreAuthorize("@ss.hasPermi('system:spec:add')")
    @Log(title = "规格", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Spec spec)
    {
        return toAjax(specService.insertSpec(spec));
    }

    /**
     * 修改规格
     */
    @PreAuthorize("@ss.hasPermi('system:spec:edit')")
    @Log(title = "规格", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Spec spec)
    {
        return toAjax(specService.updateSpec(spec));
    }

    /**
     * 删除规格
     */
    @PreAuthorize("@ss.hasPermi('system:spec:remove')")
    @Log(title = "规格", businessType = BusinessType.DELETE)
	@DeleteMapping("/{id}")
    public AjaxResult remove(@PathVariable String id)
    {
        return toAjax(specService.deleteSpecById(id));
    }
}
