package com.soss.web.controller.coffee;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.soss.common.core.domain.BaseEntity;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.WechatMessage;
import com.soss.system.service.IWechatMessageService;
import com.soss.common.utils.poi.ExcelUtil;
import com.soss.common.core.page.TableDataInfo;

/**
 * 小程序信息发送Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/message")
public class WechatMessageController extends BaseController
{
    @Autowired
    private IWechatMessageService wechatMessageService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询小程序信息发送列表
     */
    @GetMapping("/list")
    public TableDataInfo list(HttpServletRequest request, BaseEntity baseEntity)
    {
        WechatMessage wechatMessage = new WechatMessage();
        LoginUser loginUser = tokenService.getLoginUser(request);
        wechatMessage.setUserId(loginUser.getOpenId());
        startPage();

        List<WechatMessage> list = wechatMessageService.selectWechatMessageList(wechatMessage);
        return getDataTable(list);
    }

    /**
     * 导出小程序信息发送列表
     */
    @PreAuthorize("@ss.hasPermi('system:message:export')")
    @Log(title = "小程序信息发送", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WechatMessage wechatMessage)
    {
        List<WechatMessage> list = wechatMessageService.selectWechatMessageList(wechatMessage);
        ExcelUtil<WechatMessage> util = new ExcelUtil<WechatMessage>(WechatMessage.class);
        util.exportExcel(response, list, "小程序信息发送数据");
    }

    /**
     * 获取小程序信息发送详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:message:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(wechatMessageService.selectWechatMessageById(id));
    }

    /**
     * 新增小程序信息发送
     */
    @PreAuthorize("@ss.hasPermi('system:message:add')")
    @Log(title = "小程序信息发送", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WechatMessage wechatMessage)
    {
        return toAjax(wechatMessageService.insertWechatMessage(wechatMessage));
    }

    /**
     * 修改小程序信息发送
     */
    @Log(title = "小程序信息发送", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WechatMessage wechatMessage)
    {
        return toAjax(wechatMessageService.updateWechatMessage(wechatMessage));
    }

    /**
     * 删除小程序信息发送
     */
    @PreAuthorize("@ss.hasPermi('system:message:remove')")
    @Log(title = "小程序信息发送", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(wechatMessageService.deleteWechatMessageByIds(ids));
    }
}
