package com.soss.web.controller.coffee;

import java.util.List;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.WechatUser;
import com.soss.system.service.IWechatUserService;
import com.soss.common.core.page.TableDataInfo;

/**
 * 微信用户小程序信息（用于发送消息）Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/wechatuser")
public class WechatUserController extends BaseController
{
    @Autowired
    private IWechatUserService wechatUserService;

    /**
     * 查询微信用户小程序信息（用于发送消息）列表
     */
    @PreAuthorize("@ss.hasPermi('system:user:list')")
    @GetMapping("/list")
    public TableDataInfo list(WechatUser wechatUser)
    {
        startPage();
        List<WechatUser> list = wechatUserService.selectWechatUserList(wechatUser);
        return getDataTable(list);
    }


    /**
     * 获取微信用户小程序信息（用于发送消息）详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:user:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(wechatUserService.selectWechatUserById(id));
    }

    /**
     * 新增微信用户小程序信息（用于发送消息）
     */
    @PreAuthorize("@ss.hasPermi('system:user:add')")
    @Log(title = "微信用户小程序信息（用于发送消息）", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WechatUser wechatUser)
    {
        return toAjax(wechatUserService.insertWechatUser(wechatUser));
    }

    /**
     * 修改微信用户小程序信息（用于发送消息）
     */
    @Log(title = "微信用户小程序信息（用于发送消息）", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WechatUser wechatUser)
    {
        return toAjax(wechatUserService.updateWechatUser(wechatUser));
    }

    /**
     * 删除微信用户小程序信息（用于发送消息）
     */
    @PreAuthorize("@ss.hasPermi('system:user:remove')")
    @Log(title = "微信用户小程序信息（用于发送消息）", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(wechatUserService.deleteWechatUserByIds(ids));
    }
}
