package com.soss.web.controller.coffee;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.constant.Constants;
import com.soss.common.core.domain.AjaxResult;
import com.soss.framework.web.service.WeixinServiceImpl;
import com.soss.system.mapper.OrderMapper;
import com.soss.system.service.impl.AppServiceImpl;
import com.soss.system.service.impl.OrderServiceImpl;
import com.soss.system.service.impl.OrderTakingServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/weixin")
@Slf4j
public class WeixinController {

    @Autowired
    WeixinServiceImpl weixinService;
    @Autowired
    private AppServiceImpl appService;
    @Autowired
    private OrderTakingServiceImpl orderTakingService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderServiceImpl orderService;

    //这个就是那个使用传code进来的接口
    @PostMapping("/login")
    public AjaxResult login(@RequestBody String body){
        JSONObject param = JSONObject.parseObject(body);
        String code =param.getString("code");

       return AjaxResult.success(weixinService.login(code));

    }
    @PostMapping("/decrypt")
    public AjaxResult decrypt(@RequestBody String body){
        JSONObject param = JSONObject.parseObject(body);
        String encryptedData = param.getString("encryptedData");
        String iv = param.getString("iv");
        String source = param.getString("source");
        String openId = param.getString("openId");
        String sessionKey = param.getString("session_key");
        AjaxResult ajax = AjaxResult.success();
        Map<String, String> decrypt = weixinService.decrypt(encryptedData, iv, source, openId, sessionKey);
        ajax.put(Constants.TOKEN, decrypt.get("token"));
        ajax.put("phoneNumber", decrypt.get("phoneNumber"));
        ajax.put("customerName",decrypt.get("customerName"));
        return ajax;

    }
    @PostMapping("/refreshToken")
    public AjaxResult getRefreshToken(@RequestBody String body){
        JSONObject param = JSONObject.parseObject(body);
        String phoneNumber = param.getString("phoneNumber");
        String token = weixinService.refresh(phoneNumber);
        AjaxResult ajax = AjaxResult.success();
        ajax.put(Constants.TOKEN, token);
        return ajax;
    }



    /**
     * 支付通知
     * 微信支付通过支付通知接口将用户支付成功消息通知给商户
     */
    @PostMapping("/native/notify")
    public String wxNotify(HttpServletRequest request) throws Exception {

        System.out.println("微信发送的回调");
        return weixinService.wxNotify(request);

    }


    @RequestMapping("/getShop")
    public AjaxResult getShop(@RequestParam(required = false)String lng,@RequestParam(required = false)String lat){
        return AjaxResult.success(appService.getShop(lng,lat));
    }
    @RequestMapping("/getArea")
    public AjaxResult getArea(@RequestParam(required = false) String lng,@RequestParam(required = false)String lat){
        List<JSONObject> area = weixinService.getArea(lng,lat);
        return AjaxResult.success(area);
    }



    @GetMapping(value = "/infoByShop")
    public AjaxResult infoByShop(String shopId)
    {
        return AjaxResult.success(orderTakingService.getInfoByShop(shopId));
    }

    /**
     * 退款回调
     *
     * @param xmlData
     * @return
     */
    @RequestMapping(method = RequestMethod.POST, value = "/refundNotify")
    public String refundNotify(@RequestBody String xmlData) {
        log.info("微信退款回调数据为；【{}】",xmlData);
        return weixinService.refundNotify(xmlData);

    }
}
