package com.soss.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;

/**
 * 商品对象 goods
 * 
 * @author zxq
 * @date 2022-04-28
 */
public class Goods extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private long id;

    /** 商品名称 */
    @Excel(name = "商品名称")
    private String name;

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    /** 商品分类 */
    @Excel(name = "商品分类")
    private String category;

    private String categoryName;

    /** 原售价 */
    @Excel(name = "原售价")
    private BigDecimal price;

    /** 折扣价 */
    @Excel(name = "折扣价")
    private BigDecimal discount;

    /** 制作用时 单位 秒 */
    @Excel(name = "制作用时 单位 秒")
    private Long takeTime;

    /** 规格信息 形如 [{“spec_name”:”规格1”,”其他属性”:”属性1”,”rules”:[“rule1_name”:”rule1”,”属性1”:”1111”]},{“spec_name”:”规格2”,”其他属性”:”属性2”,”rules”:[“rule1_name”:”rule2”,”属性2”:”2222”]}] */
    @Excel(name = "规格信息 形如 [{“spec_name”:”规格1”,”其他属性”:”属性1”,”rules”:[“rule1_name”:”rule1”,”属性1”:”1111”]},{“spec_name”:”规格2”,”其他属性”:”属性2”,”rules”:[“rule1_name”:”rule2”,”属性2”:”2222”]}]")
    private String spec;

    /** 商品图片信息，json字符串形式 如 {“点单屏”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]},“小程序”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]}} */
    @Excel(name = "商品图片信息，json字符串形式 如 {“点单屏”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]},“小程序”:{“缩略图”:[”地址1”,”地址2”],”介绍图”:[“地址3”,”地址4”]}}")
    private String pics;

    /** 描述 */
    @Excel(name = "描述")
    private String desc;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 商品状态 1 已创建
     2 已完成编程
     3 已上架
     4 已下架
     5 已删除
     */
    @Excel(name = "商品状态 1 正常 2 暂停")
    private String state;

    /** 0 正常 1 删除 */
    @Excel(name = "0 正常 1 删除")
    private Long isDeleted;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    public Date getShelfAt() {
        return shelfAt;
    }

    public void setShelfAt(Date shelfAt) {
        this.shelfAt = shelfAt;
    }

    public Date getRecommendDate() {
        return recommendDate;
    }

    public void setRecommendDate(Date recommendDate) {
        this.recommendDate = recommendDate;
    }

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date shelfAt;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:dd")
    private Date recommendDate;

    public Integer getSalesVolume() {
        return salesVolume;
    }

    public void setSalesVolume(Integer salesVolume) {
        this.salesVolume = salesVolume;
    }

    public String getRecommend() {
        return recommend;
    }

    public void setRecommend(String recommend) {
        this.recommend = recommend;
    }

    public String getPreferential() {
        return preferential;
    }

    public void setPreferential(String preferential) {
        this.preferential = preferential;
    }

    private String recommend;

    private String preferential;
    /**
     * 总销量
     */
    private Integer salesVolume;

    /** 商品编码 */
    @Excel(name = "商品编码")
    private String code;

    private List<String> goodsTagList;


    public List<String> getGoodsTagList() {
        return goodsTagList;
    }

    public void setGoodsTagList(List<String> goodsTagList) {
        this.goodsTagList = goodsTagList;
    }
    public void setId(long id)
    {
        this.id = id;
    }

    public long getId()
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setCategory(String category) 
    {
        this.category = category;
    }

    public String getCategory() 
    {
        return category;
    }
    public void setPrice(BigDecimal price) 
    {
        this.price = price;
    }

    public BigDecimal getPrice() 
    {
        return price;
    }
    public void setDiscount(BigDecimal discount) 
    {
        this.discount = discount;
    }

    public BigDecimal getDiscount() 
    {
        return discount;
    }
    public void setTakeTime(Long takeTime) 
    {
        this.takeTime = takeTime;
    }

    public Long getTakeTime() 
    {
        return takeTime;
    }
    public void setSpec(String spec) 
    {
        this.spec = spec;
    }

    public String getSpec() 
    {
        return spec;
    }
    public void setPics(String pics) 
    {
        this.pics = pics;
    }

    public String getPics() 
    {
        return pics;
    }
    public void setDesc(String desc) 
    {
        this.desc = desc;
    }

    public String getDesc() 
    {
        return desc;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
    public void setState(String state) 
    {
        this.state = state;
    }

    public String getState() 
    {
        return state;
    }
    public void setIsDeleted(Long isDeleted) 
    {
        this.isDeleted = isDeleted;
    }

    public Long getIsDeleted() 
    {
        return isDeleted;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }
    public void setCode(String code) 
    {
        this.code = code;
    }

    public String getCode() 
    {
        return code;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("category", getCategory())
            .append("price", getPrice())
            .append("discount", getDiscount())
            .append("takeTime", getTakeTime())
            .append("spec", getSpec())
            .append("pics", getPics())
            .append("desc", getDesc())
            .append("remarks", getRemarks())
            .append("state", getState())
            .append("isDeleted", getIsDeleted())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("code", getCode())
            .toString();
    }
}
