package com.soss.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;

/**
 * 由规格选项组合生成商品sku对象 goods_sku
 * 
 * @author zxq
 * @date 2022-04-28
 */
public class GoodsSku extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private long id;

    /** 商品ID */
    @Excel(name = "商品ID")
    private long goodsId;

    /** 所有规格选项组合，形如 [{"spec_id:1,"rule_id"2"}] */
    @Excel(name = "所有规格选项组合，形如 [{'spec_id:1,'rule_id'2'}]")
    private String ruleList;

    /** 是否删除0否1是 */
    @Excel(name = "是否删除0否1是")
    private String isDeleted;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    /** 价格 */
    @Excel(name = "价格")
    private BigDecimal price;

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    private BigDecimal discount;

    public void setId(long id)
    {
        this.id = id;
    }

    public long getId()
    {
        return id;
    }
    public void setGoodsId(long goodsId)
    {
        this.goodsId = goodsId;
    }

    public long getGoodsId()
    {
        return goodsId;
    }
    public void setRuleList(String ruleList) 
    {
        this.ruleList = ruleList;
    }

    public String getRuleList() 
    {
        return ruleList;
    }
    public void setIsDeleted(String isDeleted) 
    {
        this.isDeleted = isDeleted;
    }

    public String getIsDeleted() 
    {
        return isDeleted;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }
    public void setPrice(BigDecimal price) 
    {
        this.price = price;
    }

    public BigDecimal getPrice() 
    {
        return price;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("goodsId", getGoodsId())
            .append("ruleList", getRuleList())
            .append("isDeleted", getIsDeleted())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("price", getPrice())
            .toString();
    }
}
