package com.soss.system.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;

/**
 * 订单详情对象 order_detail
 * 
 * @author zxq
 * @date 2022-04-28
 */
public class OrderDetail implements Serializable
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private String id;

    /** 订单ID */
    @Excel(name = "订单ID")
    private long orderId;

    /** 商品ID */
    @Excel(name = "商品ID")
    private String goodsId;

    /** 商品名称 */
    @Excel(name = "商品名称")
    private String goodsName;

    /** 机器ID */
    @Excel(name = "机器ID")
    private String machineId;

    /** 数量 */
    @Excel(name = "数量")
    private String num;

    /** 应付金额 */
    @Excel(name = "应付金额")
    private BigDecimal amount;

    /** 实付金额 */
    @Excel(name = "实付金额")
    private BigDecimal realAmount;

    /** 规格选项详情 */
    @Excel(name = "规格选项详情")
    private String specRuleDetail;

    /** 规格选项id集合 */
    @Excel(name = "规格选项id集合")
    private String specRuleIds;

    /** sku ID */
    @Excel(name = "sku ID")
    private String skuId;

    /** 商品分类 */
    @Excel(name = "商品分类")
    private String goodsCategory;

    public Goods getGoods() {
        return goods;
    }

    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    private Goods goods;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd ")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }
    public void setOrderId(long orderId)
    {
        this.orderId = orderId;
    }

    public long getOrderId()
    {
        return orderId;
    }
    public void setGoodsId(String goodsId) 
    {
        this.goodsId = goodsId;
    }

    public String getGoodsId() 
    {
        return goodsId;
    }
    public void setGoodsName(String goodsName) 
    {
        this.goodsName = goodsName;
    }

    public String getGoodsName() 
    {
        return goodsName;
    }
    public void setMachineId(String machineId) 
    {
        this.machineId = machineId;
    }

    public String getMachineId() 
    {
        return machineId;
    }
    public void setNum(String num) 
    {
        this.num = num;
    }

    public String getNum() 
    {
        return num;
    }
    public void setAmount(BigDecimal amount) 
    {
        this.amount = amount;
    }

    public BigDecimal getAmount() 
    {
        return amount;
    }
    public void setRealAmount(BigDecimal realAmount) 
    {
        this.realAmount = realAmount;
    }

    public BigDecimal getRealAmount() 
    {
        return realAmount;
    }
    public void setSpecRuleDetail(String specRuleDetail) 
    {
        this.specRuleDetail = specRuleDetail;
    }

    public String getSpecRuleDetail() 
    {
        return specRuleDetail;
    }
    public void setSpecRuleIds(String specRuleIds) 
    {
        this.specRuleIds = specRuleIds;
    }

    public String getSpecRuleIds() 
    {
        return specRuleIds;
    }
    public void setSkuId(String skuId) 
    {
        this.skuId = skuId;
    }

    public String getSkuId() 
    {
        return skuId;
    }
    public void setGoodsCategory(String goodsCategory) 
    {
        this.goodsCategory = goodsCategory;
    }

    public String getGoodsCategory() 
    {
        return goodsCategory;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("orderId", getOrderId())
            .append("goodsId", getGoodsId())
            .append("goodsName", getGoodsName())
            .append("machineId", getMachineId())
            .append("num", getNum())
            .append("amount", getAmount())
            .append("realAmount", getRealAmount())
            .append("specRuleDetail", getSpecRuleDetail())
            .append("specRuleIds", getSpecRuleIds())
            .append("skuId", getSkuId())
            .append("goodsCategory", getGoodsCategory())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .toString();
    }
}
