package com.soss.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;

/**
 * 店铺对象 shop
 * 
 * @author zxq
 * @date 2022-04-28
 */
public class Shop extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private long id;

    /** 店铺名称 */
    @Excel(name = "店铺名称")
    private String name;

    /** 店铺编码 */
    @Excel(name = "店铺编码")
    private String code;

    /** 店铺位置经度 */
    @Excel(name = "店铺位置经度")
    private String lng;

    /** 店铺位置纬度 */
    @Excel(name = "店铺位置纬度")
    private String lat;

    /** 店铺备注 */
    @Excel(name = "店铺备注")
    private String remarks;

    /** 店铺开始营业时间 */
    @Excel(name = "店铺开始营业时间")
    private String startTime;

    /** 店铺结束营业时间 */
    @Excel(name = "店铺结束营业时间")
    private String endTime;

    /** 店铺地址 */
    @Excel(name = "店铺地址")
    private String address;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String province;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String city;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String zone;

    public String getDistance() {
        return distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    /** 店铺状态 1 正常 2 暂停营业 3 关闭 */
    @Excel(name = "店铺状态 1 正常 2 暂停营业 3 关闭")
    private String state;

    public String getMachieStatus() {
        return machieStatus;
    }

    public void setMachieStatus(String machieStatus) {
        this.machieStatus = machieStatus;
    }

    private String distance;

    private String machieStatus;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    public String getMachineCode() {
        return machineCode;
    }

    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }

    private String machineCode;

    public int getMachineCount() {
        return machineCount;
    }

    public void setMachineCount(int machineCount) {
        this.machineCount = machineCount;
    }

    public BigDecimal getSalesAmount() {
        return salesAmount;
    }

    public void setSalesAmount(BigDecimal salesAmount) {
        this.salesAmount = salesAmount;
    }

    public Integer getSalesVolume() {
        return salesVolume;
    }

    public void setSalesVolume(Integer salesVolume) {
        this.salesVolume = salesVolume;
    }

    /** 是否默认 0否1是 */
    @Excel(name = "是否默认 0否1是")
    private Long isDefault;

    private int machineCount;


    /**
     *
     */
    private BigDecimal salesAmount;

    private Integer salesVolume;


    public void setId(long id)
    {
        this.id = id;
    }

    public long getId()
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setCode(String code) 
    {
        this.code = code;
    }

    public String getCode() 
    {
        return code;
    }
    public void setLng(String lng) 
    {
        this.lng = lng;
    }

    public String getLng() 
    {
        return lng;
    }
    public void setLat(String lat) 
    {
        this.lat = lat;
    }

    public String getLat() 
    {
        return lat;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
    public void setStartTime(String startTime) 
    {
        this.startTime = startTime;
    }

    public String getStartTime() 
    {
        return startTime;
    }
    public void setEndTime(String endTime) 
    {
        this.endTime = endTime;
    }

    public String getEndTime() 
    {
        return endTime;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setProvince(String province) 
    {
        this.province = province;
    }

    public String getProvince() 
    {
        return province;
    }
    public void setCity(String city) 
    {
        this.city = city;
    }

    public String getCity() 
    {
        return city;
    }
    public void setZone(String zone) 
    {
        this.zone = zone;
    }

    public String getZone() 
    {
        return zone;
    }
    public void setState(String state) 
    {
        this.state = state;
    }

    public String getState() 
    {
        return state;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }
    public void setIsDefault(Long isDefault) 
    {
        this.isDefault = isDefault;
    }

    public Long getIsDefault() 
    {
        return isDefault;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("code", getCode())
            .append("lng", getLng())
            .append("lat", getLat())
            .append("remarks", getRemarks())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("address", getAddress())
            .append("province", getProvince())
            .append("city", getCity())
            .append("zone", getZone())
            .append("state", getState())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("isDefault", getIsDefault())
            .toString();
    }
}
