package com.soss.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;

/**
 * 推荐和今日特惠对象 shop_recommend
 * 
 * @author zxq
 * @date 2022-04-28
 */
public class ShopRecommend extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private String id;

    /** 店铺ID */
    @Excel(name = "店铺ID")
    private String shopId;

    /** 机器ID */
    @Excel(name = "机器ID")
    private Long machineId;

    /** 推荐商品ID */
    @Excel(name = "推荐商品ID")
    private String goodsId;

    /** 商品名称 */
    @Excel(name = "商品名称")
    private String goodsName;

    /** 图片地址 */
    @Excel(name = "图片地址")
    private String pic;

    /** 推荐排序 */
    @Excel(name = "推荐排序")
    private String turn;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /** 描述 */
    @Excel(name = "描述")
    private String desc;

    private String name;

    /** 类型 1 点单屏推荐 2  今日特惠 */
    @Excel(name = "类型 1 点单屏推荐 2  今日特惠")
    private String type;

    /** 推荐状态 1 正常 2 暂停 3 移除 */
    @Excel(name = "推荐状态 1 正常 2 暂停 3 移除")
    private String state;

    /** 推荐时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "推荐时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date recDate;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }
    public void setShopId(String shopId) 
    {
        this.shopId = shopId;
    }

    public String getShopId() 
    {
        return shopId;
    }
    public void setMachineId(Long machineId) 
    {
        this.machineId = machineId;
    }

    public Long getMachineId() 
    {
        return machineId;
    }
    public void setGoodsId(String goodsId) 
    {
        this.goodsId = goodsId;
    }

    public String getGoodsId() 
    {
        return goodsId;
    }
    public void setGoodsName(String goodsName) 
    {
        this.goodsName = goodsName;
    }

    public String getGoodsName() 
    {
        return goodsName;
    }
    public void setPic(String pic) 
    {
        this.pic = pic;
    }

    public String getPic() 
    {
        return pic;
    }
    public void setTurn(String turn) 
    {
        this.turn = turn;
    }

    public String getTurn() 
    {
        return turn;
    }
    public void setDesc(String desc) 
    {
        this.desc = desc;
    }

    public String getDesc() 
    {
        return desc;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setState(String state) 
    {
        this.state = state;
    }

    public String getState() 
    {
        return state;
    }
    public void setRecDate(Date recDate) 
    {
        this.recDate = recDate;
    }

    public Date getRecDate() 
    {
        return recDate;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("shopId", getShopId())
            .append("machineId", getMachineId())
            .append("goodsId", getGoodsId())
            .append("goodsName", getGoodsName())
            .append("pic", getPic())
            .append("turn", getTurn())
            .append("desc", getDesc())
            .append("type", getType())
            .append("state", getState())
            .append("recDate", getRecDate())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .toString();
    }
}
