package com.soss.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;

/**
 * 规格对象 spec
 * 
 * @author zxq
 * @date 2022-04-28
 */
public class Spec extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private long id;

    /** 规格名称 */
    @Excel(name = "规格名称")
    private String name;

    /** 规格状态1正常 2 停用 */
    @Excel(name = "规格状态1正常 2 停用")
    private int state;

    /** 是否展示选项 */
    @Excel(name = "是否展示选项")
    private Long isShow;

    /** 是否删除0否1是 */
    @Excel(name = "是否删除0否1是")
    private int isDeleted;

    /** 是否必须原料 1 否 2 是 */
    @Excel(name = "是否必须原料 1 否 2 是")
    private int isNeccessary;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;


    /** 规格编码 */
    @Excel(name = "规格编码")
    private String code;

    private List<SpecRule> specRules;

    public List<SpecRule> getSpecRules() {
        return specRules;
    }

    public void setSpecRules(List<SpecRule> specRules) {
        this.specRules = specRules;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public long getId()
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setState(int state)
    {
        this.state = state;
    }

    public int getState()
    {
        return state;
    }
    public void setIsShow(Long isShow) 
    {
        this.isShow = isShow;
    }

    public Long getIsShow() 
    {
        return isShow;
    }
    public void setIsDeleted(int isDeleted)
    {
        this.isDeleted = isDeleted;
    }

    public int getIsDeleted()
    {
        return isDeleted;
    }
    public void setIsNeccessary(int isNeccessary)
    {
        this.isNeccessary = isNeccessary;
    }

    public int getIsNeccessary()
    {
        return isNeccessary;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }
    public void setCode(String code) 
    {
        this.code = code;
    }

    public String getCode() 
    {
        return code;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("state", getState())
            .append("isShow", getIsShow())
            .append("isDeleted", getIsDeleted())
            .append("isNeccessary", getIsNeccessary())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("code", getCode())
            .toString();
    }
}
