package com.soss.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;

/**
 * 选项原料关联对象 spec_rule_material
 * 
 * @author zxq
 * @date 2022-04-28
 */
public class SpecRuleMaterial extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 规则名称 */
    @Excel(name = "规则名称")
    private String name;

    /** 规格ID */
    @Excel(name = "规格ID")
    private Long specId;

    /** 选项ID */
    @Excel(name = "选项ID")
    private Long ruleId;

    /** 原料ID */
    @Excel(name = "原料ID")
    private Long materialId;

    /** 原料名称 */
    @Excel(name = "原料名称")
    private String materialName;

    /** 原料数量 */
    @Excel(name = "原料数量")
    private String quantity;

    /** 原料计量单位 */
    @Excel(name = "原料计量单位")
    private String unit;

    /** 是否删除0 否1是 */
    @Excel(name = "是否删除0 否1是")
    private String isDeleted;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setSpecId(Long specId)
    {
        this.specId = specId;
    }

    public Long getSpecId()
    {
        return specId;
    }
    public void setRuleId(long ruleId)
    {
        this.ruleId = ruleId;
    }

    public Long getRuleId()
    {
        return ruleId;
    }
    public void setMaterialId(Long materialId)
    {
        this.materialId = materialId;
    }

    public Long getMaterialId()
    {
        return materialId;
    }
    public void setMaterialName(String materialName) 
    {
        this.materialName = materialName;
    }

    public String getMaterialName() 
    {
        return materialName;
    }
    public void setQuantity(String quantity) 
    {
        this.quantity = quantity;
    }

    public String getQuantity() 
    {
        return quantity;
    }
    public void setUnit(String unit) 
    {
        this.unit = unit;
    }

    public String getUnit() 
    {
        return unit;
    }
    public void setIsDeleted(String isDeleted) 
    {
        this.isDeleted = isDeleted;
    }

    public String getIsDeleted() 
    {
        return isDeleted;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("specId", getSpecId())
            .append("ruleId", getRuleId())
            .append("materialId", getMaterialId())
            .append("materialName", getMaterialName())
            .append("quantity", getQuantity())
            .append("unit", getUnit())
            .append("isDeleted", getIsDeleted())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .toString();
    }
}
