package com.soss.system.jiguang.impl;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.utils.StringUtils;
import com.soss.system.domain.Machine;
import com.soss.system.domain.Order;
import com.soss.system.domain.vo.PushBean;
import com.soss.system.jiguang.JiGuangPushService;
import com.soss.system.jiguang.MyJiGuangPushService;
import com.soss.system.mapper.MachineMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 推送服务
 * 封装业务功能相关
 */
@Service
public class JiGuangPushServiceImpl implements JiGuangPushService {
    /** 一次推送最大数量 (极光限制1000) */
    private static final int max_size = 800;
    @Autowired
    private MyJiGuangPushService jPushService;
    @Autowired
    private MachineMapper machineMapper;
    /**
     * 推送全部, 不支持附加信息
     * @return
     */
    @Override
    public boolean pushAll(PushBean pushBean){
        return jPushService.pushAll(pushBean);
    }
    /**
     * 推送全部ios
     * @return
     */
    @Override
    public boolean pushIos(PushBean pushBean){
        return jPushService.pushIos(pushBean);
    }
    /**
     * 推送ios 指定id
     * @return
     */
    @Override
    public boolean pushIos(PushBean pushBean, String... registids){
        registids = checkRegistids(registids); // 剔除无效registed
        while (registids.length > max_size) { // 每次推送max_size个
            jPushService.pushIos(pushBean, Arrays.copyOfRange(registids, 0, max_size));
            registids = Arrays.copyOfRange(registids, max_size, registids.length);
        }
        return jPushService.pushIos(pushBean, registids);
    }
    /**
     * 推送全部android
     * @return
     */
    @Override
    public boolean pushAndroid(PushBean pushBean){
        return jPushService.pushAndroid(pushBean);
    }
    /**
     * 推送android 指定id
     * @return
     */
    @Override
    public boolean pushAndroid(PushBean pushBean, String... registids){
        registids = checkRegistids(registids); // 剔除无效registed
        while (registids.length > max_size) { // 每次推送max_size个
            jPushService.pushAndroid(pushBean, Arrays.copyOfRange(registids, 0, max_size));
            registids = Arrays.copyOfRange(registids, max_size, registids.length);
        }
        return jPushService.pushAndroid(pushBean, registids);
    }
    /**
     * 剔除无效registed
     * @param registids
     * @return
     */
    @Override
    public String[] checkRegistids(String[] registids) {
        List<String> regList = new ArrayList<String>(registids.length);
        for (String registid : registids) {
            if (registid!=null && !"".equals(registid.trim())) {
                regList.add(registid);
            }
        }
        return regList.toArray(new String[0]);
    }

    public void push(String key, JSONObject jsonObject) {
        String s = machineMapper.selectRegister(key);
        if(StringUtils.isNotEmpty(s)){
            PushBean pushBean = new PushBean();
            pushBean.setMessageCount(jsonObject);
            pushAndroid(pushBean,s);
        }
    }
    public void pushMachine(String machineId, Map<String, String> map) {
        Machine machine = machineMapper.selectMachineById(machineId);
        if(StringUtils.isNotEmpty(machine.getRegister())){
            PushBean pushBean = new PushBean();
            pushBean.setExtras(map);
            pushBean.setAlert("新消息");

            pushAndroid(pushBean,machine.getRegister());
        }
    }

    public void pushOrderState(Order order) {

        Machine machine = machineMapper.selectMachineById(order.getMachineId());
        if(StringUtils.isNotEmpty(machine.getRegister())){
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("action","ORDER_STATE_CHANGED");
            jsonObject.put("timestamp",System.currentTimeMillis());
            JSONObject data = new JSONObject();
            data.put("orderId",order.getId());
            data.put("orderNo",order.getOrderNo());
            data.put("orderNumber",order.getOrderNum());
            data.put("state",order.getState());
            jsonObject.put("data",data);
            PushBean pushBean = new PushBean();
            pushBean.setMessageCount(jsonObject);
            pushAndroid(pushBean,machine.getRegister());
        }
    }
}
