package com.soss.system.mapper;

import java.util.List;
import com.soss.system.domain.Customer;
import com.soss.system.domain.vo.customer.CustomerQueryVo;
import com.soss.system.domain.vo.customer.CustomerResultVo;

/**
 * 用户信息Mapper接口
 * 
 * @author zxq
 * @date 2022-05-01
 */
public interface CustomerMapper 
{
    /**
     * 查询用户信息
     * 
     * @param id 用户信息主键
     * @return 用户信息
     */
    public Customer selectCustomerById(String id);

    /**
     * 查询用户信息列表
     * 
     * @param customer 用户信息
     * @return 用户信息集合
     */
    public List<Customer> selectCustomerList(Customer customer);

    /**
     * 新增用户信息
     * 
     * @param customer 用户信息
     * @return 结果
     */
    public int insertCustomer(Customer customer);

    /**
     * 修改用户信息
     * 
     * @param customer 用户信息
     * @return 结果
     */
    public int updateCustomer(Customer customer);

    /**
     * 删除用户信息
     * 
     * @param id 用户信息主键
     * @return 结果
     */
    public int deleteCustomerById(Long id);

    /**
     * 批量删除用户信息
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCustomerByIds(Long[] ids);

    List<CustomerResultVo> selectCustomerByQuery(CustomerQueryVo customer);
}
