package com.soss.system.mapper;

import java.util.List;
import com.soss.system.domain.GoodsTag;
import org.apache.ibatis.annotations.Param;

/**
 * 商品标签Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface GoodsTagMapper 
{
    /**
     * 查询商品标签
     * 
     * @param id 商品标签主键
     * @return 商品标签
     */
    public GoodsTag selectGoodsTagById(String id);

    /**
     * 查询商品标签列表
     * 
     * @param goodsTag 商品标签
     * @return 商品标签集合
     */
    public List<GoodsTag> selectGoodsTagList(GoodsTag goodsTag);

    /**
     * 新增商品标签
     * 
     * @param goodsTag 商品标签
     * @return 结果
     */
    public int insertGoodsTag(GoodsTag goodsTag);

    /**
     * 修改商品标签
     * 
     * @param goodsTag 商品标签
     * @return 结果
     */
    public int updateGoodsTag(GoodsTag goodsTag);

    /**
     * 删除商品标签
     * 
     * @param id 商品标签主键
     * @return 结果
     */
    public int deleteGoodsTagById(String id);

    /**
     * 批量删除商品标签
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteGoodsTagByIds(String[] ids);

    void deleteGoodsTagByGoodsId(@Param("goodsId") String id);
}
