package com.soss.system.mapper;

import java.util.List;
import com.soss.system.domain.OrderLog;

/**
 * 订单日志Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface OrderLogMapper 
{
    /**
     * 查询订单日志
     * 
     * @param id 订单日志主键
     * @return 订单日志
     */
    public OrderLog selectOrderLogById(String id);

    /**
     * 查询订单日志列表
     * 
     * @param orderLog 订单日志
     * @return 订单日志集合
     */
    public List<OrderLog> selectOrderLogList(OrderLog orderLog);

    /**
     * 新增订单日志
     * 
     * @param orderLog 订单日志
     * @return 结果
     */
    public int insertOrderLog(OrderLog orderLog);

    /**
     * 修改订单日志
     * 
     * @param orderLog 订单日志
     * @return 结果
     */
    public int updateOrderLog(OrderLog orderLog);

    /**
     * 删除订单日志
     * 
     * @param id 订单日志主键
     * @return 结果
     */
    public int deleteOrderLogById(String id);

    /**
     * 批量删除订单日志
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOrderLogByIds(String[] ids);
}
