package com.soss.system.mapper;

import java.util.List;

import com.soss.system.domain.GoodsSku;
import com.soss.system.domain.ShopGoodsSku;
import com.soss.system.domain.vo.orderTaking.SkuVo;
import org.apache.ibatis.annotations.Param;

/**
 * 从店铺到sku关联Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface ShopGoodsSkuMapper 
{
    /**
     * 查询从店铺到sku关联
     * 
     * @param id 从店铺到sku关联主键
     * @return 从店铺到sku关联
     */
    public ShopGoodsSku selectShopGoodsSkuById(String id);

    /**
     * 查询从店铺到sku关联列表
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 从店铺到sku关联集合
     */
    public List<ShopGoodsSku> selectShopGoodsSkuList(ShopGoodsSku shopGoodsSku);

    /**
     * 新增从店铺到sku关联
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 结果
     */
    public int insertShopGoodsSku(ShopGoodsSku shopGoodsSku);

    /**
     * 修改从店铺到sku关联
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 结果
     */
    public int updateShopGoodsSku(ShopGoodsSku shopGoodsSku);

    /**
     * 删除从店铺到sku关联
     * 
     * @param id 从店铺到sku关联主键
     * @return 结果
     */
    public int deleteShopGoodsSkuById(String id);

    /**
     * 批量删除从店铺到sku关联
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteShopGoodsSkuByIds(String[] ids);

    List<GoodsSku> selectSkuByShopAndGoods(@Param("shopId") long shopId, @Param("goodsId") long goodsId);

    List<SkuVo> selectSkuByGoodAndShop(@Param("shopId") Long shopId,@Param("goodsId") String goodId);

    void deleteShopGoodsSkuByGoodsId(@Param("goodsId") Long goodsId);

    int updateSkuStatus(@Param("skuIds") List<String> skuIds, @Param("machineCode") String robotID,@Param("shopId") String shopID,@Param("status") String status);

    void deleteByGoodsIds(@Param("shopId") Long shopId, @Param("goodsIds") List<String> goodsIds);
}
