package com.soss.system.schedule;

import com.soss.system.constants.OrderStatusConstant;
import com.soss.system.domain.Order;
import com.soss.system.mapper.OrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class OrderSchedule {
    @Autowired
    private OrderMapper orderMapper;
    @Value("${timeout}")
    private String timeout;

    @Scheduled(fixedDelay = 60*1000)
    private void process() {
        orderMapper.updateTimeOut(OrderStatusConstant.productionCompleted,timeout);
    }
}
