package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.Goods;

/**
 * 商品Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IGoodsService 
{
    /**
     * 查询商品
     * 
     * @param id 商品主键
     * @return 商品
     */
    public Goods selectGoodsById(String id);

    /**
     * 查询商品列表
     * 
     * @param goods 商品
     * @return 商品集合
     */
    public List<Goods> selectGoodsList(Goods goods);

    /**
     * 新增商品
     * 
     * @param goods 商品
     * @return 结果
     */
    public int insertGoods(Goods goods);

    /**
     * 修改商品
     * 
     * @param goods 商品
     * @return 结果
     */
    public int updateGoods(Goods goods);

    /**
     * 批量删除商品
     * 
     * @param ids 需要删除的商品主键集合
     * @return 结果
     */
    public int deleteGoodsByIds(String[] ids);

    /**
     * 删除商品信息
     * 
     * @param id 商品主键
     * @return 结果
     */
    public int deleteGoodsById(String id);

    String putShop(Long goodsId, boolean boo);

    String offShop(Long goodsId, boolean boo);

    String deleteGoodsById(Long goodsId, boolean boo);
}
