package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.GoodsSku;

/**
 * 由规格选项组合生成商品skuService接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IGoodsSkuService 
{
    /**
     * 查询由规格选项组合生成商品sku
     * 
     * @param id 由规格选项组合生成商品sku主键
     * @return 由规格选项组合生成商品sku
     */
    public GoodsSku selectGoodsSkuById(String id);

    /**
     * 查询由规格选项组合生成商品sku列表
     * 
     * @param goodsSku 由规格选项组合生成商品sku
     * @return 由规格选项组合生成商品sku集合
     */
    public List<GoodsSku> selectGoodsSkuList(GoodsSku goodsSku);

    /**
     * 新增由规格选项组合生成商品sku
     * 
     * @param goodsSku 由规格选项组合生成商品sku
     * @return 结果
     */
    public int insertGoodsSku(GoodsSku goodsSku);

    /**
     * 修改由规格选项组合生成商品sku
     * 
     * @param goodsSku 由规格选项组合生成商品sku
     * @return 结果
     */
    public int updateGoodsSku(GoodsSku goodsSku);

    /**
     * 批量删除由规格选项组合生成商品sku
     * 
     * @param ids 需要删除的由规格选项组合生成商品sku主键集合
     * @return 结果
     */
    public int deleteGoodsSkuByIds(String[] ids);

    /**
     * 删除由规格选项组合生成商品sku信息
     * 
     * @param id 由规格选项组合生成商品sku主键
     * @return 结果
     */
    public int deleteGoodsSkuById(String id);
}
