package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.Machine;

/**
 * 机器Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IMachineService 
{
    /**
     * 查询机器
     * 
     * @param id 机器主键
     * @return 机器
     */
    public Machine selectMachineById(String id);

    /**
     * 查询机器列表
     * 
     * @param machine 机器
     * @return 机器集合
     */
    public List<Machine> selectMachineList(Machine machine);

    /**
     * 新增机器
     * 
     * @param machine 机器
     * @return 结果
     */
    public int insertMachine(Machine machine);

    /**
     * 修改机器
     * 
     * @param machine 机器
     * @return 结果
     */
    public int updateMachine(Machine machine);

    /**
     * 批量删除机器
     * 
     * @param ids 需要删除的机器主键集合
     * @return 结果
     */
    public int deleteMachineByIds(String[] ids);

    /**
     * 删除机器信息
     * 
     * @param id 机器主键
     * @return 结果
     */
    public int deleteMachineById(String id);

    String bindMachine(String code, Long shopId);

    int unbound(String id);
}
