package com.soss.system.service;

import java.util.List;

import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.system.domain.Order;
import com.soss.system.domain.vo.OrderQuery;

/**
 * 订单Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IOrderService 
{
    /**
     * 查询订单
     * 
     * @param id 订单主键
     * @return 订单
     */
    public Order selectOrderById(String id);

    /**
     * 查询订单列表
     * 
     * @param order 订单
     * @return 订单集合
     */
    public List<Order> selectOrderList(OrderQuery orderQuery);

    /**
     * 新增订单
     * 
     *
     * @param request
     * @param order 订单
     * @return 结果
     */
    public AjaxResult insertOrder(LoginUser request, Order order);

    /**
     * 修改订单
     * 
     * @param order 订单
     * @return 结果
     */
    public int updateOrder(Order order);

    /**
     * 批量删除订单
     * 
     * @param ids 需要删除的订单主键集合
     * @return 结果
     */
    public int deleteOrderByIds(String[] ids);

    /**
     * 删除订单信息
     * 
     * @param id 订单主键
     * @return 结果
     */
    public int deleteOrderById(String id);

    AjaxResult check(Order order);

    List<Order> getMyOrder(String openId);

    int cancel(String orderId);
}
